package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ApprovalRuleContent,
  ApprovalRuleId,
  ApprovalRuleName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ApprovalRuleEventMetadata(
    approvalRuleName: Optional[ApprovalRuleName] = Optional.Absent,
    approvalRuleId: Optional[ApprovalRuleId] = Optional.Absent,
    approvalRuleContent: Optional[ApprovalRuleContent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ApprovalRuleEventMetadata = {
    import ApprovalRuleEventMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ApprovalRuleEventMetadata
      .builder()
      .optionallyWith(
        approvalRuleName.map(value =>
          ApprovalRuleName.unwrap(value): java.lang.String
        )
      )(_.approvalRuleName)
      .optionallyWith(
        approvalRuleId.map(value =>
          ApprovalRuleId.unwrap(value): java.lang.String
        )
      )(_.approvalRuleId)
      .optionallyWith(
        approvalRuleContent.map(value =>
          ApprovalRuleContent.unwrap(value): java.lang.String
        )
      )(_.approvalRuleContent)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.ApprovalRuleEventMetadata.ReadOnly =
    zio.aws.codecommit.model.ApprovalRuleEventMetadata.wrap(buildAwsValue())
}
object ApprovalRuleEventMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ApprovalRuleEventMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ApprovalRuleEventMetadata =
      zio.aws.codecommit.model.ApprovalRuleEventMetadata(
        approvalRuleName.map(value => value),
        approvalRuleId.map(value => value),
        approvalRuleContent.map(value => value)
      )
    def approvalRuleName: Optional[ApprovalRuleName]
    def approvalRuleId: Optional[ApprovalRuleId]
    def approvalRuleContent: Optional[ApprovalRuleContent]
    def getApprovalRuleName: ZIO[Any, AwsError, ApprovalRuleName] =
      AwsError.unwrapOptionField("approvalRuleName", approvalRuleName)
    def getApprovalRuleId: ZIO[Any, AwsError, ApprovalRuleId] =
      AwsError.unwrapOptionField("approvalRuleId", approvalRuleId)
    def getApprovalRuleContent: ZIO[Any, AwsError, ApprovalRuleContent] =
      AwsError.unwrapOptionField("approvalRuleContent", approvalRuleContent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ApprovalRuleEventMetadata
  ) extends zio.aws.codecommit.model.ApprovalRuleEventMetadata.ReadOnly {
    override val approvalRuleName: Optional[ApprovalRuleName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvalRuleName())
        .map(value =>
          zio.aws.codecommit.model.primitives.ApprovalRuleName(value)
        )
    override val approvalRuleId: Optional[ApprovalRuleId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvalRuleId())
        .map(value => zio.aws.codecommit.model.primitives.ApprovalRuleId(value))
    override val approvalRuleContent: Optional[ApprovalRuleContent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvalRuleContent())
        .map(value =>
          zio.aws.codecommit.model.primitives.ApprovalRuleContent(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ApprovalRuleEventMetadata
  ): zio.aws.codecommit.model.ApprovalRuleEventMetadata.ReadOnly = new Wrapper(
    impl
  )
}
