package zio.aws.codecommit.model
import scala.jdk.CollectionConverters.*
sealed trait PullRequestEventType {
  def unwrap
      : software.amazon.awssdk.services.codecommit.model.PullRequestEventType
}
object PullRequestEventType {
  def wrap(
      value: software.amazon.awssdk.services.codecommit.model.PullRequestEventType
  ): zio.aws.codecommit.model.PullRequestEventType = value match {
    case software.amazon.awssdk.services.codecommit.model.PullRequestEventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecommit.model.PullRequestEventType.PULL_REQUEST_CREATED =>
      val r = PULL_REQUEST_CREATED
      r
    case software.amazon.awssdk.services.codecommit.model.PullRequestEventType.PULL_REQUEST_STATUS_CHANGED =>
      val r = PULL_REQUEST_STATUS_CHANGED
      r
    case software.amazon.awssdk.services.codecommit.model.PullRequestEventType.PULL_REQUEST_SOURCE_REFERENCE_UPDATED =>
      val r = PULL_REQUEST_SOURCE_REFERENCE_UPDATED
      r
    case software.amazon.awssdk.services.codecommit.model.PullRequestEventType.PULL_REQUEST_MERGE_STATE_CHANGED =>
      val r = PULL_REQUEST_MERGE_STATE_CHANGED
      r
    case software.amazon.awssdk.services.codecommit.model.PullRequestEventType.PULL_REQUEST_APPROVAL_RULE_CREATED =>
      val r = PULL_REQUEST_APPROVAL_RULE_CREATED
      r
    case software.amazon.awssdk.services.codecommit.model.PullRequestEventType.PULL_REQUEST_APPROVAL_RULE_UPDATED =>
      val r = PULL_REQUEST_APPROVAL_RULE_UPDATED
      r
    case software.amazon.awssdk.services.codecommit.model.PullRequestEventType.PULL_REQUEST_APPROVAL_RULE_DELETED =>
      val r = PULL_REQUEST_APPROVAL_RULE_DELETED
      r
    case software.amazon.awssdk.services.codecommit.model.PullRequestEventType.PULL_REQUEST_APPROVAL_RULE_OVERRIDDEN =>
      val r = PULL_REQUEST_APPROVAL_RULE_OVERRIDDEN
      r
    case software.amazon.awssdk.services.codecommit.model.PullRequestEventType.PULL_REQUEST_APPROVAL_STATE_CHANGED =>
      val r = PULL_REQUEST_APPROVAL_STATE_CHANGED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codecommit.model.PullRequestEventType {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.PullRequestEventType =
      software.amazon.awssdk.services.codecommit.model.PullRequestEventType.UNKNOWN_TO_SDK_VERSION
  }
  case object PULL_REQUEST_CREATED
      extends zio.aws.codecommit.model.PullRequestEventType {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.PullRequestEventType =
      software.amazon.awssdk.services.codecommit.model.PullRequestEventType.PULL_REQUEST_CREATED
  }
  case object PULL_REQUEST_STATUS_CHANGED
      extends zio.aws.codecommit.model.PullRequestEventType {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.PullRequestEventType =
      software.amazon.awssdk.services.codecommit.model.PullRequestEventType.PULL_REQUEST_STATUS_CHANGED
  }
  case object PULL_REQUEST_SOURCE_REFERENCE_UPDATED
      extends zio.aws.codecommit.model.PullRequestEventType {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.PullRequestEventType =
      software.amazon.awssdk.services.codecommit.model.PullRequestEventType.PULL_REQUEST_SOURCE_REFERENCE_UPDATED
  }
  case object PULL_REQUEST_MERGE_STATE_CHANGED
      extends zio.aws.codecommit.model.PullRequestEventType {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.PullRequestEventType =
      software.amazon.awssdk.services.codecommit.model.PullRequestEventType.PULL_REQUEST_MERGE_STATE_CHANGED
  }
  case object PULL_REQUEST_APPROVAL_RULE_CREATED
      extends zio.aws.codecommit.model.PullRequestEventType {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.PullRequestEventType =
      software.amazon.awssdk.services.codecommit.model.PullRequestEventType.PULL_REQUEST_APPROVAL_RULE_CREATED
  }
  case object PULL_REQUEST_APPROVAL_RULE_UPDATED
      extends zio.aws.codecommit.model.PullRequestEventType {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.PullRequestEventType =
      software.amazon.awssdk.services.codecommit.model.PullRequestEventType.PULL_REQUEST_APPROVAL_RULE_UPDATED
  }
  case object PULL_REQUEST_APPROVAL_RULE_DELETED
      extends zio.aws.codecommit.model.PullRequestEventType {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.PullRequestEventType =
      software.amazon.awssdk.services.codecommit.model.PullRequestEventType.PULL_REQUEST_APPROVAL_RULE_DELETED
  }
  case object PULL_REQUEST_APPROVAL_RULE_OVERRIDDEN
      extends zio.aws.codecommit.model.PullRequestEventType {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.PullRequestEventType =
      software.amazon.awssdk.services.codecommit.model.PullRequestEventType.PULL_REQUEST_APPROVAL_RULE_OVERRIDDEN
  }
  case object PULL_REQUEST_APPROVAL_STATE_CHANGED
      extends zio.aws.codecommit.model.PullRequestEventType {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.PullRequestEventType =
      software.amazon.awssdk.services.codecommit.model.PullRequestEventType.PULL_REQUEST_APPROVAL_STATE_CHANGED
  }
}
