package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{ApprovalRuleName, PullRequestId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeletePullRequestApprovalRuleRequest(
    pullRequestId: PullRequestId,
    approvalRuleName: ApprovalRuleName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleRequest = {
    import DeletePullRequestApprovalRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleRequest
      .builder()
      .pullRequestId(PullRequestId.unwrap(pullRequestId): java.lang.String)
      .approvalRuleName(
        ApprovalRuleName.unwrap(approvalRuleName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.DeletePullRequestApprovalRuleRequest.ReadOnly =
    zio.aws.codecommit.model.DeletePullRequestApprovalRuleRequest
      .wrap(buildAwsValue())
}
object DeletePullRequestApprovalRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.DeletePullRequestApprovalRuleRequest =
      zio.aws.codecommit.model
        .DeletePullRequestApprovalRuleRequest(pullRequestId, approvalRuleName)
    def pullRequestId: PullRequestId
    def approvalRuleName: ApprovalRuleName
    def getPullRequestId: ZIO[Any, Nothing, PullRequestId] =
      ZIO.succeed(pullRequestId)
    def getApprovalRuleName: ZIO[Any, Nothing, ApprovalRuleName] =
      ZIO.succeed(approvalRuleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleRequest
  ) extends zio.aws.codecommit.model.DeletePullRequestApprovalRuleRequest.ReadOnly {
    override val pullRequestId: PullRequestId =
      zio.aws.codecommit.model.primitives.PullRequestId(impl.pullRequestId())
    override val approvalRuleName: ApprovalRuleName =
      zio.aws.codecommit.model.primitives
        .ApprovalRuleName(impl.approvalRuleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleRequest
  ): zio.aws.codecommit.model.DeletePullRequestApprovalRuleRequest.ReadOnly =
    new Wrapper(impl)
}
