package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListRepositoriesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    sortBy: Optional[zio.aws.codecommit.model.SortByEnum] = Optional.Absent,
    order: Optional[zio.aws.codecommit.model.OrderEnum] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest = {
    import ListRepositoriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(order.map(value => value.unwrap))(_.order)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.ListRepositoriesRequest.ReadOnly =
    zio.aws.codecommit.model.ListRepositoriesRequest.wrap(buildAwsValue())
}
object ListRepositoriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ListRepositoriesRequest =
      zio.aws.codecommit.model.ListRepositoriesRequest(
        nextToken.map(value => value),
        sortBy.map(value => value),
        order.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def sortBy: Optional[zio.aws.codecommit.model.SortByEnum]
    def order: Optional[zio.aws.codecommit.model.OrderEnum]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy: ZIO[Any, AwsError, zio.aws.codecommit.model.SortByEnum] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getOrder: ZIO[Any, AwsError, zio.aws.codecommit.model.OrderEnum] =
      AwsError.unwrapOptionField("order", order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest
  ) extends zio.aws.codecommit.model.ListRepositoriesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
    override val sortBy: Optional[zio.aws.codecommit.model.SortByEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.codecommit.model.SortByEnum.wrap(value))
    override val order: Optional[zio.aws.codecommit.model.OrderEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.order())
        .map(value => zio.aws.codecommit.model.OrderEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest
  ): zio.aws.codecommit.model.ListRepositoriesRequest.ReadOnly = new Wrapper(
    impl
  )
}
