package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{AdditionalData, Message, ObjectId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Commit(
    commitId: Optional[ObjectId] = Optional.Absent,
    treeId: Optional[ObjectId] = Optional.Absent,
    parents: Optional[Iterable[ObjectId]] = Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    author: Optional[zio.aws.codecommit.model.UserInfo] = Optional.Absent,
    committer: Optional[zio.aws.codecommit.model.UserInfo] = Optional.Absent,
    additionalData: Optional[AdditionalData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.Commit = {
    import Commit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.Commit
      .builder()
      .optionallyWith(
        commitId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.commitId)
      .optionallyWith(
        treeId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.treeId)
      .optionallyWith(
        parents.map(value =>
          value.map { item =>
            ObjectId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.parents)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(author.map(value => value.buildAwsValue()))(_.author)
      .optionallyWith(committer.map(value => value.buildAwsValue()))(
        _.committer
      )
      .optionallyWith(
        additionalData.map(value =>
          AdditionalData.unwrap(value): java.lang.String
        )
      )(_.additionalData)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.Commit.ReadOnly =
    zio.aws.codecommit.model.Commit.wrap(buildAwsValue())
}
object Commit {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.codecommit.model.Commit] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.Commit =
      zio.aws.codecommit.model.Commit(
        commitId.map(value => value),
        treeId.map(value => value),
        parents.map(value => value),
        message.map(value => value),
        author.map(value => value.asEditable),
        committer.map(value => value.asEditable),
        additionalData.map(value => value)
      )
    def commitId: Optional[ObjectId]
    def treeId: Optional[ObjectId]
    def parents: Optional[List[ObjectId]]
    def message: Optional[Message]
    def author: Optional[zio.aws.codecommit.model.UserInfo.ReadOnly]
    def committer: Optional[zio.aws.codecommit.model.UserInfo.ReadOnly]
    def additionalData: Optional[AdditionalData]
    def getCommitId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("commitId", commitId)
    def getTreeId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("treeId", treeId)
    def getParents: ZIO[Any, AwsError, List[ObjectId]] =
      AwsError.unwrapOptionField("parents", parents)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getAuthor
        : ZIO[Any, AwsError, zio.aws.codecommit.model.UserInfo.ReadOnly] =
      AwsError.unwrapOptionField("author", author)
    def getCommitter
        : ZIO[Any, AwsError, zio.aws.codecommit.model.UserInfo.ReadOnly] =
      AwsError.unwrapOptionField("committer", committer)
    def getAdditionalData: ZIO[Any, AwsError, AdditionalData] =
      AwsError.unwrapOptionField("additionalData", additionalData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.Commit
  ) extends zio.aws.codecommit.model.Commit.ReadOnly {
    override val commitId: Optional[ObjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.commitId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val treeId: Optional[ObjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.treeId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val parents: Optional[List[ObjectId]] = zio.aws.core.internal
      .optionalFromNullable(impl.parents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.primitives.ObjectId(item)
        }.toList
      )
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.codecommit.model.primitives.Message(value))
    override val author: Optional[zio.aws.codecommit.model.UserInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.author())
        .map(value => zio.aws.codecommit.model.UserInfo.wrap(value))
    override val committer
        : Optional[zio.aws.codecommit.model.UserInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.committer())
        .map(value => zio.aws.codecommit.model.UserInfo.wrap(value))
    override val additionalData: Optional[AdditionalData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalData())
        .map(value => zio.aws.codecommit.model.primitives.AdditionalData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.Commit
  ): zio.aws.codecommit.model.Commit.ReadOnly = new Wrapper(impl)
}
