package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{Message, ExceptionName, Path}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchDescribeMergeConflictsError(
    filePath: Path,
    exceptionName: ExceptionName,
    message: Message
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsError = {
    import BatchDescribeMergeConflictsError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsError
      .builder()
      .filePath(Path.unwrap(filePath): java.lang.String)
      .exceptionName(ExceptionName.unwrap(exceptionName): java.lang.String)
      .message(Message.unwrap(message): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.BatchDescribeMergeConflictsError.ReadOnly =
    zio.aws.codecommit.model.BatchDescribeMergeConflictsError
      .wrap(buildAwsValue())
}
object BatchDescribeMergeConflictsError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.BatchDescribeMergeConflictsError =
      zio.aws.codecommit.model
        .BatchDescribeMergeConflictsError(filePath, exceptionName, message)
    def filePath: Path
    def exceptionName: ExceptionName
    def message: Message
    def getFilePath: ZIO[Any, Nothing, Path] = ZIO.succeed(filePath)
    def getExceptionName: ZIO[Any, Nothing, ExceptionName] =
      ZIO.succeed(exceptionName)
    def getMessage: ZIO[Any, Nothing, Message] = ZIO.succeed(message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsError
  ) extends zio.aws.codecommit.model.BatchDescribeMergeConflictsError.ReadOnly {
    override val filePath: Path =
      zio.aws.codecommit.model.primitives.Path(impl.filePath())
    override val exceptionName: ExceptionName =
      zio.aws.codecommit.model.primitives.ExceptionName(impl.exceptionName())
    override val message: Message =
      zio.aws.codecommit.model.primitives.Message(impl.message())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsError
  ): zio.aws.codecommit.model.BatchDescribeMergeConflictsError.ReadOnly =
    new Wrapper(impl)
}
