package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{ObjectId, RepositoryName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetBlobRequest(
    repositoryName: RepositoryName,
    blobId: ObjectId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetBlobRequest = {
    import GetBlobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetBlobRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .blobId(ObjectId.unwrap(blobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetBlobRequest.ReadOnly =
    zio.aws.codecommit.model.GetBlobRequest.wrap(buildAwsValue())
}
object GetBlobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetBlobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetBlobRequest =
      zio.aws.codecommit.model.GetBlobRequest(repositoryName, blobId)
    def repositoryName: RepositoryName
    def blobId: ObjectId
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getBlobId: ZIO[Any, Nothing, ObjectId] = ZIO.succeed(blobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetBlobRequest
  ) extends zio.aws.codecommit.model.GetBlobRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val blobId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.blobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetBlobRequest
  ): zio.aws.codecommit.model.GetBlobRequest.ReadOnly = new Wrapper(impl)
}
