package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{ObjectId, Path}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FileMetadata(
    absolutePath: Optional[Path] = Optional.Absent,
    blobId: Optional[ObjectId] = Optional.Absent,
    fileMode: Optional[zio.aws.codecommit.model.FileModeTypeEnum] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.FileMetadata = {
    import FileMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.FileMetadata
      .builder()
      .optionallyWith(
        absolutePath.map(value => Path.unwrap(value): java.lang.String)
      )(_.absolutePath)
      .optionallyWith(
        blobId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.blobId)
      .optionallyWith(fileMode.map(value => value.unwrap))(_.fileMode)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.FileMetadata.ReadOnly =
    zio.aws.codecommit.model.FileMetadata.wrap(buildAwsValue())
}
object FileMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.FileMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.FileMetadata =
      zio.aws.codecommit.model.FileMetadata(
        absolutePath.map(value => value),
        blobId.map(value => value),
        fileMode.map(value => value)
      )
    def absolutePath: Optional[Path]
    def blobId: Optional[ObjectId]
    def fileMode: Optional[zio.aws.codecommit.model.FileModeTypeEnum]
    def getAbsolutePath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("absolutePath", absolutePath)
    def getBlobId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("blobId", blobId)
    def getFileMode
        : ZIO[Any, AwsError, zio.aws.codecommit.model.FileModeTypeEnum] =
      AwsError.unwrapOptionField("fileMode", fileMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.FileMetadata
  ) extends zio.aws.codecommit.model.FileMetadata.ReadOnly {
    override val absolutePath: Optional[Path] = zio.aws.core.internal
      .optionalFromNullable(impl.absolutePath())
      .map(value => zio.aws.codecommit.model.primitives.Path(value))
    override val blobId: Optional[ObjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.blobId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val fileMode: Optional[zio.aws.codecommit.model.FileModeTypeEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileMode())
        .map(value => zio.aws.codecommit.model.FileModeTypeEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.FileMetadata
  ): zio.aws.codecommit.model.FileMetadata.ReadOnly = new Wrapper(impl)
}
