package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{NextToken, BranchName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListBranchesResponse(
    branches: Option[Iterable[BranchName]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ListBranchesResponse = {
    import ListBranchesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ListBranchesResponse
      .builder()
      .optionallyWith(
        branches.map(value =>
          value.map { item =>
            BranchName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.branches)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.ListBranchesResponse.ReadOnly =
    zio.aws.codecommit.model.ListBranchesResponse.wrap(buildAwsValue())
}
object ListBranchesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ListBranchesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ListBranchesResponse =
      zio.aws.codecommit.model.ListBranchesResponse(
        branches.map(value => value),
        nextToken.map(value => value)
      )
    def branches: Option[List[BranchName]]
    def nextToken: Option[NextToken]
    def getBranches: ZIO[Any, AwsError, List[BranchName]] =
      AwsError.unwrapOptionField("branches", branches)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ListBranchesResponse
  ) extends zio.aws.codecommit.model.ListBranchesResponse.ReadOnly {
    override val branches: Option[List[BranchName]] = scala
      .Option(impl.branches())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.primitives.BranchName(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ListBranchesResponse
  ): zio.aws.codecommit.model.ListBranchesResponse.ReadOnly = new Wrapper(impl)
}
