package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{FileContent, Path}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ReplaceContentEntry(
    filePath: Path,
    replacementType: zio.aws.codecommit.model.ReplacementTypeEnum,
    content: Option[FileContent] = None,
    fileMode: Option[zio.aws.codecommit.model.FileModeTypeEnum] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ReplaceContentEntry = {
    import ReplaceContentEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ReplaceContentEntry
      .builder()
      .filePath(Path.unwrap(filePath): java.lang.String)
      .replacementType(replacementType.unwrap)
      .optionallyWith(
        content.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.content)
      .optionallyWith(fileMode.map(value => value.unwrap))(_.fileMode)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.ReplaceContentEntry.ReadOnly =
    zio.aws.codecommit.model.ReplaceContentEntry.wrap(buildAwsValue())
}
object ReplaceContentEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ReplaceContentEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ReplaceContentEntry =
      zio.aws.codecommit.model.ReplaceContentEntry(
        filePath,
        replacementType,
        content.map(value => value),
        fileMode.map(value => value)
      )
    def filePath: Path
    def replacementType: zio.aws.codecommit.model.ReplacementTypeEnum
    def content: Option[FileContent]
    def fileMode: Option[zio.aws.codecommit.model.FileModeTypeEnum]
    def getFilePath: ZIO[Any, Nothing, Path] = ZIO.succeed(filePath)
    def getReplacementType
        : ZIO[Any, Nothing, zio.aws.codecommit.model.ReplacementTypeEnum] =
      ZIO.succeed(replacementType)
    def getContent: ZIO[Any, AwsError, FileContent] =
      AwsError.unwrapOptionField("content", content)
    def getFileMode
        : ZIO[Any, AwsError, zio.aws.codecommit.model.FileModeTypeEnum] =
      AwsError.unwrapOptionField("fileMode", fileMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ReplaceContentEntry
  ) extends zio.aws.codecommit.model.ReplaceContentEntry.ReadOnly {
    override val filePath: Path =
      zio.aws.codecommit.model.primitives.Path(impl.filePath())
    override val replacementType: zio.aws.codecommit.model.ReplacementTypeEnum =
      zio.aws.codecommit.model.ReplacementTypeEnum.wrap(impl.replacementType())
    override val content: Option[FileContent] = scala
      .Option(impl.content())
      .map(value =>
        zio.aws.codecommit.model.primitives
          .FileContent(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val fileMode: Option[zio.aws.codecommit.model.FileModeTypeEnum] =
      scala
        .Option(impl.fileMode())
        .map(value => zio.aws.codecommit.model.FileModeTypeEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ReplaceContentEntry
  ): zio.aws.codecommit.model.ReplaceContentEntry.ReadOnly = new Wrapper(impl)
}
