package zio.aws.codecommit.model
import scala.jdk.CollectionConverters.*
sealed trait ConflictDetailLevelTypeEnum {
  def unwrap: software.amazon.awssdk.services.codecommit.model.ConflictDetailLevelTypeEnum
}
object ConflictDetailLevelTypeEnum {
  def wrap(
      value: software.amazon.awssdk.services.codecommit.model.ConflictDetailLevelTypeEnum
  ): zio.aws.codecommit.model.ConflictDetailLevelTypeEnum = value match {
    case software.amazon.awssdk.services.codecommit.model.ConflictDetailLevelTypeEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecommit.model.ConflictDetailLevelTypeEnum.FILE_LEVEL =>
      val r = FILE_LEVEL
      r
    case software.amazon.awssdk.services.codecommit.model.ConflictDetailLevelTypeEnum.LINE_LEVEL =>
      val r = LINE_LEVEL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codecommit.model.ConflictDetailLevelTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ConflictDetailLevelTypeEnum =
      software.amazon.awssdk.services.codecommit.model.ConflictDetailLevelTypeEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object FILE_LEVEL
      extends zio.aws.codecommit.model.ConflictDetailLevelTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ConflictDetailLevelTypeEnum =
      software.amazon.awssdk.services.codecommit.model.ConflictDetailLevelTypeEnum.FILE_LEVEL
  }
  case object LINE_LEVEL
      extends zio.aws.codecommit.model.ConflictDetailLevelTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ConflictDetailLevelTypeEnum =
      software.amazon.awssdk.services.codecommit.model.ConflictDetailLevelTypeEnum.LINE_LEVEL
  }
}
