package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.PullRequestId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdatePullRequestStatusRequest(
    pullRequestId: PullRequestId,
    pullRequestStatus: zio.aws.codecommit.model.PullRequestStatusEnum
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.UpdatePullRequestStatusRequest = {
    import UpdatePullRequestStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.UpdatePullRequestStatusRequest
      .builder()
      .pullRequestId(PullRequestId.unwrap(pullRequestId): java.lang.String)
      .pullRequestStatus(pullRequestStatus.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.UpdatePullRequestStatusRequest.ReadOnly =
    zio.aws.codecommit.model.UpdatePullRequestStatusRequest
      .wrap(buildAwsValue())
}
object UpdatePullRequestStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.UpdatePullRequestStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.UpdatePullRequestStatusRequest =
      zio.aws.codecommit.model
        .UpdatePullRequestStatusRequest(pullRequestId, pullRequestStatus)
    def pullRequestId: PullRequestId
    def pullRequestStatus: zio.aws.codecommit.model.PullRequestStatusEnum
    def getPullRequestId: ZIO[Any, Nothing, PullRequestId] =
      ZIO.succeed(pullRequestId)
    def getPullRequestStatus
        : ZIO[Any, Nothing, zio.aws.codecommit.model.PullRequestStatusEnum] =
      ZIO.succeed(pullRequestStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.UpdatePullRequestStatusRequest
  ) extends zio.aws.codecommit.model.UpdatePullRequestStatusRequest.ReadOnly {
    override val pullRequestId: PullRequestId =
      zio.aws.codecommit.model.primitives.PullRequestId(impl.pullRequestId())
    override val pullRequestStatus
        : zio.aws.codecommit.model.PullRequestStatusEnum =
      zio.aws.codecommit.model.PullRequestStatusEnum
        .wrap(impl.pullRequestStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.UpdatePullRequestStatusRequest
  ): zio.aws.codecommit.model.UpdatePullRequestStatusRequest.ReadOnly =
    new Wrapper(impl)
}
