package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ClientRequestToken,
  Content,
  CommitId,
  RepositoryName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PostCommentForComparedCommitRequest(
    repositoryName: RepositoryName,
    beforeCommitId: Option[CommitId] = None,
    afterCommitId: CommitId,
    location: Option[zio.aws.codecommit.model.Location] = None,
    content: Content,
    clientRequestToken: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitRequest = {
    import PostCommentForComparedCommitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .optionallyWith(
        beforeCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.beforeCommitId)
      .afterCommitId(CommitId.unwrap(afterCommitId): java.lang.String)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .content(Content.unwrap(content): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.PostCommentForComparedCommitRequest.ReadOnly =
    zio.aws.codecommit.model.PostCommentForComparedCommitRequest
      .wrap(buildAwsValue())
}
object PostCommentForComparedCommitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.PostCommentForComparedCommitRequest =
      zio.aws.codecommit.model.PostCommentForComparedCommitRequest(
        repositoryName,
        beforeCommitId.map(value => value),
        afterCommitId,
        location.map(value => value.asEditable),
        content,
        clientRequestToken.map(value => value)
      )
    def repositoryName: RepositoryName
    def beforeCommitId: Option[CommitId]
    def afterCommitId: CommitId
    def location: Option[zio.aws.codecommit.model.Location.ReadOnly]
    def content: Content
    def clientRequestToken: Option[ClientRequestToken]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getBeforeCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("beforeCommitId", beforeCommitId)
    def getAfterCommitId: ZIO[Any, Nothing, CommitId] =
      ZIO.succeed(afterCommitId)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.codecommit.model.Location.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getContent: ZIO[Any, Nothing, Content] = ZIO.succeed(content)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitRequest
  ) extends zio.aws.codecommit.model.PostCommentForComparedCommitRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val beforeCommitId: Option[CommitId] = scala
      .Option(impl.beforeCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val afterCommitId: CommitId =
      zio.aws.codecommit.model.primitives.CommitId(impl.afterCommitId())
    override val location: Option[zio.aws.codecommit.model.Location.ReadOnly] =
      scala
        .Option(impl.location())
        .map(value => zio.aws.codecommit.model.Location.wrap(value))
    override val content: Content =
      zio.aws.codecommit.model.primitives.Content(impl.content())
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.codecommit.model.primitives.ClientRequestToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitRequest
  ): zio.aws.codecommit.model.PostCommentForComparedCommitRequest.ReadOnly =
    new Wrapper(impl)
}
