package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{Position, Path}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Location(
    filePath: Option[Path] = None,
    filePosition: Option[Position] = None,
    relativeFileVersion: Option[
      zio.aws.codecommit.model.RelativeFileVersionEnum
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.Location = {
    import Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.Location
      .builder()
      .optionallyWith(
        filePath.map(value => Path.unwrap(value): java.lang.String)
      )(_.filePath)
      .optionallyWith(
        filePosition.map(value => Position.unwrap(value): java.lang.Long)
      )(_.filePosition)
      .optionallyWith(relativeFileVersion.map(value => value.unwrap))(
        _.relativeFileVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.Location.ReadOnly =
    zio.aws.codecommit.model.Location.wrap(buildAwsValue())
}
object Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.Location =
      zio.aws.codecommit.model.Location(
        filePath.map(value => value),
        filePosition.map(value => value),
        relativeFileVersion.map(value => value)
      )
    def filePath: Option[Path]
    def filePosition: Option[Position]
    def relativeFileVersion
        : Option[zio.aws.codecommit.model.RelativeFileVersionEnum]
    def getFilePath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("filePath", filePath)
    def getFilePosition: ZIO[Any, AwsError, Position] =
      AwsError.unwrapOptionField("filePosition", filePosition)
    def getRelativeFileVersion
        : ZIO[Any, AwsError, zio.aws.codecommit.model.RelativeFileVersionEnum] =
      AwsError.unwrapOptionField("relativeFileVersion", relativeFileVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.Location
  ) extends zio.aws.codecommit.model.Location.ReadOnly {
    override val filePath: Option[Path] = scala
      .Option(impl.filePath())
      .map(value => zio.aws.codecommit.model.primitives.Path(value))
    override val filePosition: Option[Position] = scala
      .Option(impl.filePosition())
      .map(value => zio.aws.codecommit.model.primitives.Position(value))
    override val relativeFileVersion
        : Option[zio.aws.codecommit.model.RelativeFileVersionEnum] = scala
      .Option(impl.relativeFileVersion())
      .map(value =>
        zio.aws.codecommit.model.RelativeFileVersionEnum.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.Location
  ): zio.aws.codecommit.model.Location.ReadOnly = new Wrapper(impl)
}
