package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  CommitName,
  NextToken,
  RepositoryName,
  Limit,
  Path
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDifferencesRequest(
    repositoryName: RepositoryName,
    beforeCommitSpecifier: Option[CommitName] = None,
    afterCommitSpecifier: CommitName,
    beforePath: Option[Path] = None,
    afterPath: Option[Path] = None,
    maxResults: Option[Limit] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest = {
    import GetDifferencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .optionallyWith(
        beforeCommitSpecifier.map(value =>
          CommitName.unwrap(value): java.lang.String
        )
      )(_.beforeCommitSpecifier)
      .afterCommitSpecifier(
        CommitName.unwrap(afterCommitSpecifier): java.lang.String
      )
      .optionallyWith(
        beforePath.map(value => Path.unwrap(value): java.lang.String)
      )(_.beforePath)
      .optionallyWith(
        afterPath.map(value => Path.unwrap(value): java.lang.String)
      )(_.afterPath)
      .optionallyWith(maxResults.map(value => Limit.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetDifferencesRequest.ReadOnly =
    zio.aws.codecommit.model.GetDifferencesRequest.wrap(buildAwsValue())
}
object GetDifferencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetDifferencesRequest =
      zio.aws.codecommit.model.GetDifferencesRequest(
        repositoryName,
        beforeCommitSpecifier.map(value => value),
        afterCommitSpecifier,
        beforePath.map(value => value),
        afterPath.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def repositoryName: RepositoryName
    def beforeCommitSpecifier: Option[CommitName]
    def afterCommitSpecifier: CommitName
    def beforePath: Option[Path]
    def afterPath: Option[Path]
    def maxResults: Option[Limit]
    def nextToken: Option[NextToken]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getBeforeCommitSpecifier: ZIO[Any, AwsError, CommitName] =
      AwsError.unwrapOptionField("beforeCommitSpecifier", beforeCommitSpecifier)
    def getAfterCommitSpecifier: ZIO[Any, Nothing, CommitName] =
      ZIO.succeed(afterCommitSpecifier)
    def getBeforePath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("beforePath", beforePath)
    def getAfterPath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("afterPath", afterPath)
    def getMaxResults: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest
  ) extends zio.aws.codecommit.model.GetDifferencesRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val beforeCommitSpecifier: Option[CommitName] = scala
      .Option(impl.beforeCommitSpecifier())
      .map(value => zio.aws.codecommit.model.primitives.CommitName(value))
    override val afterCommitSpecifier: CommitName =
      zio.aws.codecommit.model.primitives
        .CommitName(impl.afterCommitSpecifier())
    override val beforePath: Option[Path] = scala
      .Option(impl.beforePath())
      .map(value => zio.aws.codecommit.model.primitives.Path(value))
    override val afterPath: Option[Path] = scala
      .Option(impl.afterPath())
      .map(value => zio.aws.codecommit.model.primitives.Path(value))
    override val maxResults: Option[Limit] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codecommit.model.primitives.Limit(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest
  ): zio.aws.codecommit.model.GetDifferencesRequest.ReadOnly = new Wrapper(impl)
}
