package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MergePullRequestByThreeWayResponse(
    pullRequest: Option[zio.aws.codecommit.model.PullRequest] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.MergePullRequestByThreeWayResponse = {
    import MergePullRequestByThreeWayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.MergePullRequestByThreeWayResponse
      .builder()
      .optionallyWith(pullRequest.map(value => value.buildAwsValue()))(
        _.pullRequest
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.MergePullRequestByThreeWayResponse.ReadOnly =
    zio.aws.codecommit.model.MergePullRequestByThreeWayResponse
      .wrap(buildAwsValue())
}
object MergePullRequestByThreeWayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.MergePullRequestByThreeWayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.MergePullRequestByThreeWayResponse =
      zio.aws.codecommit.model.MergePullRequestByThreeWayResponse(
        pullRequest.map(value => value.asEditable)
      )
    def pullRequest: Option[zio.aws.codecommit.model.PullRequest.ReadOnly]
    def getPullRequest
        : ZIO[Any, AwsError, zio.aws.codecommit.model.PullRequest.ReadOnly] =
      AwsError.unwrapOptionField("pullRequest", pullRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.MergePullRequestByThreeWayResponse
  ) extends zio.aws.codecommit.model.MergePullRequestByThreeWayResponse.ReadOnly {
    override val pullRequest
        : Option[zio.aws.codecommit.model.PullRequest.ReadOnly] = scala
      .Option(impl.pullRequest())
      .map(value => zio.aws.codecommit.model.PullRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.MergePullRequestByThreeWayResponse
  ): zio.aws.codecommit.model.MergePullRequestByThreeWayResponse.ReadOnly =
    new Wrapper(impl)
}
