package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{Arn, EventDate, PullRequestId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class PullRequestEvent(
    pullRequestId: Option[PullRequestId] = None,
    eventDate: Option[EventDate] = None,
    pullRequestEventType: Option[
      zio.aws.codecommit.model.PullRequestEventType
    ] = None,
    actorArn: Option[Arn] = None,
    pullRequestCreatedEventMetadata: Option[
      zio.aws.codecommit.model.PullRequestCreatedEventMetadata
    ] = None,
    pullRequestStatusChangedEventMetadata: Option[
      zio.aws.codecommit.model.PullRequestStatusChangedEventMetadata
    ] = None,
    pullRequestSourceReferenceUpdatedEventMetadata: Option[
      zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata
    ] = None,
    pullRequestMergedStateChangedEventMetadata: Option[
      zio.aws.codecommit.model.PullRequestMergedStateChangedEventMetadata
    ] = None,
    approvalRuleEventMetadata: Option[
      zio.aws.codecommit.model.ApprovalRuleEventMetadata
    ] = None,
    approvalStateChangedEventMetadata: Option[
      zio.aws.codecommit.model.ApprovalStateChangedEventMetadata
    ] = None,
    approvalRuleOverriddenEventMetadata: Option[
      zio.aws.codecommit.model.ApprovalRuleOverriddenEventMetadata
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PullRequestEvent = {
    import PullRequestEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PullRequestEvent
      .builder()
      .optionallyWith(
        pullRequestId.map(value =>
          PullRequestId.unwrap(value): java.lang.String
        )
      )(_.pullRequestId)
      .optionallyWith(eventDate.map(value => EventDate.unwrap(value): Instant))(
        _.eventDate
      )
      .optionallyWith(pullRequestEventType.map(value => value.unwrap))(
        _.pullRequestEventType
      )
      .optionallyWith(
        actorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.actorArn)
      .optionallyWith(
        pullRequestCreatedEventMetadata.map(value => value.buildAwsValue())
      )(_.pullRequestCreatedEventMetadata)
      .optionallyWith(
        pullRequestStatusChangedEventMetadata.map(value =>
          value.buildAwsValue()
        )
      )(_.pullRequestStatusChangedEventMetadata)
      .optionallyWith(
        pullRequestSourceReferenceUpdatedEventMetadata.map(value =>
          value.buildAwsValue()
        )
      )(_.pullRequestSourceReferenceUpdatedEventMetadata)
      .optionallyWith(
        pullRequestMergedStateChangedEventMetadata.map(value =>
          value.buildAwsValue()
        )
      )(_.pullRequestMergedStateChangedEventMetadata)
      .optionallyWith(
        approvalRuleEventMetadata.map(value => value.buildAwsValue())
      )(_.approvalRuleEventMetadata)
      .optionallyWith(
        approvalStateChangedEventMetadata.map(value => value.buildAwsValue())
      )(_.approvalStateChangedEventMetadata)
      .optionallyWith(
        approvalRuleOverriddenEventMetadata.map(value => value.buildAwsValue())
      )(_.approvalRuleOverriddenEventMetadata)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.PullRequestEvent.ReadOnly =
    zio.aws.codecommit.model.PullRequestEvent.wrap(buildAwsValue())
}
object PullRequestEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PullRequestEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.PullRequestEvent =
      zio.aws.codecommit.model.PullRequestEvent(
        pullRequestId.map(value => value),
        eventDate.map(value => value),
        pullRequestEventType.map(value => value),
        actorArn.map(value => value),
        pullRequestCreatedEventMetadata.map(value => value.asEditable),
        pullRequestStatusChangedEventMetadata.map(value => value.asEditable),
        pullRequestSourceReferenceUpdatedEventMetadata.map(value =>
          value.asEditable
        ),
        pullRequestMergedStateChangedEventMetadata.map(value =>
          value.asEditable
        ),
        approvalRuleEventMetadata.map(value => value.asEditable),
        approvalStateChangedEventMetadata.map(value => value.asEditable),
        approvalRuleOverriddenEventMetadata.map(value => value.asEditable)
      )
    def pullRequestId: Option[PullRequestId]
    def eventDate: Option[EventDate]
    def pullRequestEventType
        : Option[zio.aws.codecommit.model.PullRequestEventType]
    def actorArn: Option[Arn]
    def pullRequestCreatedEventMetadata: Option[
      zio.aws.codecommit.model.PullRequestCreatedEventMetadata.ReadOnly
    ]
    def pullRequestStatusChangedEventMetadata: Option[
      zio.aws.codecommit.model.PullRequestStatusChangedEventMetadata.ReadOnly
    ]
    def pullRequestSourceReferenceUpdatedEventMetadata: Option[
      zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata.ReadOnly
    ]
    def pullRequestMergedStateChangedEventMetadata: Option[
      zio.aws.codecommit.model.PullRequestMergedStateChangedEventMetadata.ReadOnly
    ]
    def approvalRuleEventMetadata
        : Option[zio.aws.codecommit.model.ApprovalRuleEventMetadata.ReadOnly]
    def approvalStateChangedEventMetadata: Option[
      zio.aws.codecommit.model.ApprovalStateChangedEventMetadata.ReadOnly
    ]
    def approvalRuleOverriddenEventMetadata: Option[
      zio.aws.codecommit.model.ApprovalRuleOverriddenEventMetadata.ReadOnly
    ]
    def getPullRequestId: ZIO[Any, AwsError, PullRequestId] =
      AwsError.unwrapOptionField("pullRequestId", pullRequestId)
    def getEventDate: ZIO[Any, AwsError, EventDate] =
      AwsError.unwrapOptionField("eventDate", eventDate)
    def getPullRequestEventType
        : ZIO[Any, AwsError, zio.aws.codecommit.model.PullRequestEventType] =
      AwsError.unwrapOptionField("pullRequestEventType", pullRequestEventType)
    def getActorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("actorArn", actorArn)
    def getPullRequestCreatedEventMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.PullRequestCreatedEventMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pullRequestCreatedEventMetadata",
      pullRequestCreatedEventMetadata
    )
    def getPullRequestStatusChangedEventMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.PullRequestStatusChangedEventMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pullRequestStatusChangedEventMetadata",
      pullRequestStatusChangedEventMetadata
    )
    def getPullRequestSourceReferenceUpdatedEventMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pullRequestSourceReferenceUpdatedEventMetadata",
      pullRequestSourceReferenceUpdatedEventMetadata
    )
    def getPullRequestMergedStateChangedEventMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.PullRequestMergedStateChangedEventMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pullRequestMergedStateChangedEventMetadata",
      pullRequestMergedStateChangedEventMetadata
    )
    def getApprovalRuleEventMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ApprovalRuleEventMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "approvalRuleEventMetadata",
      approvalRuleEventMetadata
    )
    def getApprovalStateChangedEventMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ApprovalStateChangedEventMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "approvalStateChangedEventMetadata",
      approvalStateChangedEventMetadata
    )
    def getApprovalRuleOverriddenEventMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ApprovalRuleOverriddenEventMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "approvalRuleOverriddenEventMetadata",
      approvalRuleOverriddenEventMetadata
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequestEvent
  ) extends zio.aws.codecommit.model.PullRequestEvent.ReadOnly {
    override val pullRequestId: Option[PullRequestId] = scala
      .Option(impl.pullRequestId())
      .map(value => zio.aws.codecommit.model.primitives.PullRequestId(value))
    override val eventDate: Option[EventDate] = scala
      .Option(impl.eventDate())
      .map(value => zio.aws.codecommit.model.primitives.EventDate(value))
    override val pullRequestEventType
        : Option[zio.aws.codecommit.model.PullRequestEventType] = scala
      .Option(impl.pullRequestEventType())
      .map(value => zio.aws.codecommit.model.PullRequestEventType.wrap(value))
    override val actorArn: Option[Arn] = scala
      .Option(impl.actorArn())
      .map(value => zio.aws.codecommit.model.primitives.Arn(value))
    override val pullRequestCreatedEventMetadata: Option[
      zio.aws.codecommit.model.PullRequestCreatedEventMetadata.ReadOnly
    ] = scala
      .Option(impl.pullRequestCreatedEventMetadata())
      .map(value =>
        zio.aws.codecommit.model.PullRequestCreatedEventMetadata.wrap(value)
      )
    override val pullRequestStatusChangedEventMetadata: Option[
      zio.aws.codecommit.model.PullRequestStatusChangedEventMetadata.ReadOnly
    ] = scala
      .Option(impl.pullRequestStatusChangedEventMetadata())
      .map(value =>
        zio.aws.codecommit.model.PullRequestStatusChangedEventMetadata
          .wrap(value)
      )
    override val pullRequestSourceReferenceUpdatedEventMetadata: Option[
      zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata.ReadOnly
    ] = scala
      .Option(impl.pullRequestSourceReferenceUpdatedEventMetadata())
      .map(value =>
        zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata
          .wrap(value)
      )
    override val pullRequestMergedStateChangedEventMetadata: Option[
      zio.aws.codecommit.model.PullRequestMergedStateChangedEventMetadata.ReadOnly
    ] = scala
      .Option(impl.pullRequestMergedStateChangedEventMetadata())
      .map(value =>
        zio.aws.codecommit.model.PullRequestMergedStateChangedEventMetadata
          .wrap(value)
      )
    override val approvalRuleEventMetadata
        : Option[zio.aws.codecommit.model.ApprovalRuleEventMetadata.ReadOnly] =
      scala
        .Option(impl.approvalRuleEventMetadata())
        .map(value =>
          zio.aws.codecommit.model.ApprovalRuleEventMetadata.wrap(value)
        )
    override val approvalStateChangedEventMetadata: Option[
      zio.aws.codecommit.model.ApprovalStateChangedEventMetadata.ReadOnly
    ] = scala
      .Option(impl.approvalStateChangedEventMetadata())
      .map(value =>
        zio.aws.codecommit.model.ApprovalStateChangedEventMetadata.wrap(value)
      )
    override val approvalRuleOverriddenEventMetadata: Option[
      zio.aws.codecommit.model.ApprovalRuleOverriddenEventMetadata.ReadOnly
    ] = scala
      .Option(impl.approvalRuleOverriddenEventMetadata())
      .map(value =>
        zio.aws.codecommit.model.ApprovalRuleOverriddenEventMetadata.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequestEvent
  ): zio.aws.codecommit.model.PullRequestEvent.ReadOnly = new Wrapper(impl)
}
