package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Approval(
    userArn: Option[Arn] = None,
    approvalState: Option[zio.aws.codecommit.model.ApprovalState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.Approval = {
    import Approval.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.Approval
      .builder()
      .optionallyWith(
        userArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.userArn)
      .optionallyWith(approvalState.map(value => value.unwrap))(_.approvalState)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.Approval.ReadOnly =
    zio.aws.codecommit.model.Approval.wrap(buildAwsValue())
}
object Approval {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.Approval
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.Approval = zio.aws.codecommit.model
      .Approval(userArn.map(value => value), approvalState.map(value => value))
    def userArn: Option[Arn]
    def approvalState: Option[zio.aws.codecommit.model.ApprovalState]
    def getUserArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("userArn", userArn)
    def getApprovalState
        : ZIO[Any, AwsError, zio.aws.codecommit.model.ApprovalState] =
      AwsError.unwrapOptionField("approvalState", approvalState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.Approval
  ) extends zio.aws.codecommit.model.Approval.ReadOnly {
    override val userArn: Option[Arn] = scala
      .Option(impl.userArn())
      .map(value => zio.aws.codecommit.model.primitives.Arn(value))
    override val approvalState: Option[zio.aws.codecommit.model.ApprovalState] =
      scala
        .Option(impl.approvalState())
        .map(value => zio.aws.codecommit.model.ApprovalState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.Approval
  ): zio.aws.codecommit.model.Approval.ReadOnly = new Wrapper(impl)
}
