package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Difference(
    beforeBlob: Option[zio.aws.codecommit.model.BlobMetadata] = None,
    afterBlob: Option[zio.aws.codecommit.model.BlobMetadata] = None,
    changeType: Option[zio.aws.codecommit.model.ChangeTypeEnum] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.Difference = {
    import Difference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.Difference
      .builder()
      .optionallyWith(beforeBlob.map(value => value.buildAwsValue()))(
        _.beforeBlob
      )
      .optionallyWith(afterBlob.map(value => value.buildAwsValue()))(
        _.afterBlob
      )
      .optionallyWith(changeType.map(value => value.unwrap))(_.changeType)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.Difference.ReadOnly =
    zio.aws.codecommit.model.Difference.wrap(buildAwsValue())
}
object Difference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.Difference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.Difference =
      zio.aws.codecommit.model.Difference(
        beforeBlob.map(value => value.asEditable),
        afterBlob.map(value => value.asEditable),
        changeType.map(value => value)
      )
    def beforeBlob: Option[zio.aws.codecommit.model.BlobMetadata.ReadOnly]
    def afterBlob: Option[zio.aws.codecommit.model.BlobMetadata.ReadOnly]
    def changeType: Option[zio.aws.codecommit.model.ChangeTypeEnum]
    def getBeforeBlob
        : ZIO[Any, AwsError, zio.aws.codecommit.model.BlobMetadata.ReadOnly] =
      AwsError.unwrapOptionField("beforeBlob", beforeBlob)
    def getAfterBlob
        : ZIO[Any, AwsError, zio.aws.codecommit.model.BlobMetadata.ReadOnly] =
      AwsError.unwrapOptionField("afterBlob", afterBlob)
    def getChangeType
        : ZIO[Any, AwsError, zio.aws.codecommit.model.ChangeTypeEnum] =
      AwsError.unwrapOptionField("changeType", changeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.Difference
  ) extends zio.aws.codecommit.model.Difference.ReadOnly {
    override val beforeBlob
        : Option[zio.aws.codecommit.model.BlobMetadata.ReadOnly] = scala
      .Option(impl.beforeBlob())
      .map(value => zio.aws.codecommit.model.BlobMetadata.wrap(value))
    override val afterBlob
        : Option[zio.aws.codecommit.model.BlobMetadata.ReadOnly] = scala
      .Option(impl.afterBlob())
      .map(value => zio.aws.codecommit.model.BlobMetadata.wrap(value))
    override val changeType: Option[zio.aws.codecommit.model.ChangeTypeEnum] =
      scala
        .Option(impl.changeType())
        .map(value => zio.aws.codecommit.model.ChangeTypeEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.Difference
  ): zio.aws.codecommit.model.Difference.ReadOnly = new Wrapper(impl)
}
