package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  MaxResults,
  NextToken,
  Arn,
  PullRequestId
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribePullRequestEventsRequest(
    pullRequestId: PullRequestId,
    pullRequestEventType: Option[
      zio.aws.codecommit.model.PullRequestEventType
    ] = None,
    actorArn: Option[Arn] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest = {
    import DescribePullRequestEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest
      .builder()
      .pullRequestId(PullRequestId.unwrap(pullRequestId): java.lang.String)
      .optionallyWith(pullRequestEventType.map(value => value.unwrap))(
        _.pullRequestEventType
      )
      .optionallyWith(
        actorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.actorArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.DescribePullRequestEventsRequest.ReadOnly =
    zio.aws.codecommit.model.DescribePullRequestEventsRequest
      .wrap(buildAwsValue())
}
object DescribePullRequestEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.DescribePullRequestEventsRequest =
      zio.aws.codecommit.model.DescribePullRequestEventsRequest(
        pullRequestId,
        pullRequestEventType.map(value => value),
        actorArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def pullRequestId: PullRequestId
    def pullRequestEventType
        : Option[zio.aws.codecommit.model.PullRequestEventType]
    def actorArn: Option[Arn]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getPullRequestId: ZIO[Any, Nothing, PullRequestId] =
      ZIO.succeed(pullRequestId)
    def getPullRequestEventType
        : ZIO[Any, AwsError, zio.aws.codecommit.model.PullRequestEventType] =
      AwsError.unwrapOptionField("pullRequestEventType", pullRequestEventType)
    def getActorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("actorArn", actorArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest
  ) extends zio.aws.codecommit.model.DescribePullRequestEventsRequest.ReadOnly {
    override val pullRequestId: PullRequestId =
      zio.aws.codecommit.model.primitives.PullRequestId(impl.pullRequestId())
    override val pullRequestEventType
        : Option[zio.aws.codecommit.model.PullRequestEventType] = scala
      .Option(impl.pullRequestEventType())
      .map(value => zio.aws.codecommit.model.PullRequestEventType.wrap(value))
    override val actorArn: Option[Arn] = scala
      .Option(impl.actorArn())
      .map(value => zio.aws.codecommit.model.primitives.Arn(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codecommit.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest
  ): zio.aws.codecommit.model.DescribePullRequestEventsRequest.ReadOnly =
    new Wrapper(impl)
}
