package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{RepositoryId, RepositoryName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RepositoryNameIdPair(
    repositoryName: Option[RepositoryName] = None,
    repositoryId: Option[RepositoryId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.RepositoryNameIdPair = {
    import RepositoryNameIdPair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.RepositoryNameIdPair
      .builder()
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        repositoryId.map(value => RepositoryId.unwrap(value): java.lang.String)
      )(_.repositoryId)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.RepositoryNameIdPair.ReadOnly =
    zio.aws.codecommit.model.RepositoryNameIdPair.wrap(buildAwsValue())
}
object RepositoryNameIdPair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.RepositoryNameIdPair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.RepositoryNameIdPair =
      zio.aws.codecommit.model.RepositoryNameIdPair(
        repositoryName.map(value => value),
        repositoryId.map(value => value)
      )
    def repositoryName: Option[RepositoryName]
    def repositoryId: Option[RepositoryId]
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getRepositoryId: ZIO[Any, AwsError, RepositoryId] =
      AwsError.unwrapOptionField("repositoryId", repositoryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.RepositoryNameIdPair
  ) extends zio.aws.codecommit.model.RepositoryNameIdPair.ReadOnly {
    override val repositoryName: Option[RepositoryName] = scala
      .Option(impl.repositoryName())
      .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val repositoryId: Option[RepositoryId] = scala
      .Option(impl.repositoryId())
      .map(value => zio.aws.codecommit.model.primitives.RepositoryId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.RepositoryNameIdPair
  ): zio.aws.codecommit.model.RepositoryNameIdPair.ReadOnly = new Wrapper(impl)
}
