package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{Path, ObjectId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetFolderResponse(
    commitId: ObjectId,
    folderPath: Path,
    treeId: Option[ObjectId] = None,
    subFolders: Option[Iterable[zio.aws.codecommit.model.Folder]] = None,
    files: Option[Iterable[zio.aws.codecommit.model.File]] = None,
    symbolicLinks: Option[Iterable[zio.aws.codecommit.model.SymbolicLink]] =
      None,
    subModules: Option[Iterable[zio.aws.codecommit.model.SubModule]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetFolderResponse = {
    import GetFolderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetFolderResponse
      .builder()
      .commitId(ObjectId.unwrap(commitId): java.lang.String)
      .folderPath(Path.unwrap(folderPath): java.lang.String)
      .optionallyWith(
        treeId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.treeId)
      .optionallyWith(
        subFolders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subFolders)
      .optionallyWith(
        files.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.files)
      .optionallyWith(
        symbolicLinks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.symbolicLinks)
      .optionallyWith(
        subModules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subModules)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetFolderResponse.ReadOnly =
    zio.aws.codecommit.model.GetFolderResponse.wrap(buildAwsValue())
}
object GetFolderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetFolderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetFolderResponse =
      zio.aws.codecommit.model.GetFolderResponse(
        commitId,
        folderPath,
        treeId.map(value => value),
        subFolders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        files.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        symbolicLinks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        subModules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def commitId: ObjectId
    def folderPath: Path
    def treeId: Option[ObjectId]
    def subFolders: Option[List[zio.aws.codecommit.model.Folder.ReadOnly]]
    def files: Option[List[zio.aws.codecommit.model.File.ReadOnly]]
    def symbolicLinks
        : Option[List[zio.aws.codecommit.model.SymbolicLink.ReadOnly]]
    def subModules: Option[List[zio.aws.codecommit.model.SubModule.ReadOnly]]
    def getCommitId: ZIO[Any, Nothing, ObjectId] = ZIO.succeed(commitId)
    def getFolderPath: ZIO[Any, Nothing, Path] = ZIO.succeed(folderPath)
    def getTreeId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("treeId", treeId)
    def getSubFolders
        : ZIO[Any, AwsError, List[zio.aws.codecommit.model.Folder.ReadOnly]] =
      AwsError.unwrapOptionField("subFolders", subFolders)
    def getFiles
        : ZIO[Any, AwsError, List[zio.aws.codecommit.model.File.ReadOnly]] =
      AwsError.unwrapOptionField("files", files)
    def getSymbolicLinks: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.SymbolicLink.ReadOnly
    ]] = AwsError.unwrapOptionField("symbolicLinks", symbolicLinks)
    def getSubModules: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.SubModule.ReadOnly
    ]] = AwsError.unwrapOptionField("subModules", subModules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetFolderResponse
  ) extends zio.aws.codecommit.model.GetFolderResponse.ReadOnly {
    override val commitId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.commitId())
    override val folderPath: Path =
      zio.aws.codecommit.model.primitives.Path(impl.folderPath())
    override val treeId: Option[ObjectId] = scala
      .Option(impl.treeId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val subFolders
        : Option[List[zio.aws.codecommit.model.Folder.ReadOnly]] = scala
      .Option(impl.subFolders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.Folder.wrap(item)
        }.toList
      )
    override val files: Option[List[zio.aws.codecommit.model.File.ReadOnly]] =
      scala
        .Option(impl.files())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.File.wrap(item)
          }.toList
        )
    override val symbolicLinks
        : Option[List[zio.aws.codecommit.model.SymbolicLink.ReadOnly]] = scala
      .Option(impl.symbolicLinks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.SymbolicLink.wrap(item)
        }.toList
      )
    override val subModules
        : Option[List[zio.aws.codecommit.model.SubModule.ReadOnly]] = scala
      .Option(impl.subModules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.SubModule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetFolderResponse
  ): zio.aws.codecommit.model.GetFolderResponse.ReadOnly = new Wrapper(impl)
}
