package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.RevisionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ApprovalStateChangedEventMetadata(
    revisionId: Option[RevisionId] = None,
    approvalStatus: Option[zio.aws.codecommit.model.ApprovalState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ApprovalStateChangedEventMetadata = {
    import ApprovalStateChangedEventMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ApprovalStateChangedEventMetadata
      .builder()
      .optionallyWith(
        revisionId.map(value => RevisionId.unwrap(value): java.lang.String)
      )(_.revisionId)
      .optionallyWith(approvalStatus.map(value => value.unwrap))(
        _.approvalStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.ApprovalStateChangedEventMetadata.ReadOnly =
    zio.aws.codecommit.model.ApprovalStateChangedEventMetadata
      .wrap(buildAwsValue())
}
object ApprovalStateChangedEventMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ApprovalStateChangedEventMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ApprovalStateChangedEventMetadata =
      zio.aws.codecommit.model.ApprovalStateChangedEventMetadata(
        revisionId.map(value => value),
        approvalStatus.map(value => value)
      )
    def revisionId: Option[RevisionId]
    def approvalStatus: Option[zio.aws.codecommit.model.ApprovalState]
    def getRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getApprovalStatus
        : ZIO[Any, AwsError, zio.aws.codecommit.model.ApprovalState] =
      AwsError.unwrapOptionField("approvalStatus", approvalStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ApprovalStateChangedEventMetadata
  ) extends zio.aws.codecommit.model.ApprovalStateChangedEventMetadata.ReadOnly {
    override val revisionId: Option[RevisionId] = scala
      .Option(impl.revisionId())
      .map(value => zio.aws.codecommit.model.primitives.RevisionId(value))
    override val approvalStatus
        : Option[zio.aws.codecommit.model.ApprovalState] = scala
      .Option(impl.approvalStatus())
      .map(value => zio.aws.codecommit.model.ApprovalState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ApprovalStateChangedEventMetadata
  ): zio.aws.codecommit.model.ApprovalStateChangedEventMetadata.ReadOnly =
    new Wrapper(impl)
}
