package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.FileSize
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class FileSizes(
    source: Option[FileSize] = None,
    destination: Option[FileSize] = None,
    base: Option[FileSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.FileSizes = {
    import FileSizes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.FileSizes
      .builder()
      .optionallyWith(
        source.map(value => FileSize.unwrap(value): java.lang.Long)
      )(_.source)
      .optionallyWith(
        destination.map(value => FileSize.unwrap(value): java.lang.Long)
      )(_.destination)
      .optionallyWith(
        base.map(value => FileSize.unwrap(value): java.lang.Long)
      )(_.base)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.FileSizes.ReadOnly =
    zio.aws.codecommit.model.FileSizes.wrap(buildAwsValue())
}
object FileSizes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.FileSizes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.FileSizes =
      zio.aws.codecommit.model.FileSizes(
        source.map(value => value),
        destination.map(value => value),
        base.map(value => value)
      )
    def source: Option[FileSize]
    def destination: Option[FileSize]
    def base: Option[FileSize]
    def getSource: ZIO[Any, AwsError, FileSize] =
      AwsError.unwrapOptionField("source", source)
    def getDestination: ZIO[Any, AwsError, FileSize] =
      AwsError.unwrapOptionField("destination", destination)
    def getBase: ZIO[Any, AwsError, FileSize] =
      AwsError.unwrapOptionField("base", base)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.FileSizes
  ) extends zio.aws.codecommit.model.FileSizes.ReadOnly {
    override val source: Option[FileSize] = scala
      .Option(impl.source())
      .map(value => zio.aws.codecommit.model.primitives.FileSize(value))
    override val destination: Option[FileSize] = scala
      .Option(impl.destination())
      .map(value => zio.aws.codecommit.model.primitives.FileSize(value))
    override val base: Option[FileSize] = scala
      .Option(impl.base())
      .map(value => zio.aws.codecommit.model.primitives.FileSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.FileSizes
  ): zio.aws.codecommit.model.FileSizes.ReadOnly = new Wrapper(impl)
}
