package zio.aws.codecommit.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codecommit.model.primitives.{
  IsCommentDeleted,
  CommentId,
  ClientRequestToken,
  Count,
  ReactionValue,
  Arn,
  LastModifiedDate,
  Content,
  CreationDate
}
import scala.jdk.CollectionConverters.*
final case class Comment(
    commentId: Option[CommentId] = None,
    content: Option[Content] = None,
    inReplyTo: Option[CommentId] = None,
    creationDate: Option[CreationDate] = None,
    lastModifiedDate: Option[LastModifiedDate] = None,
    authorArn: Option[Arn] = None,
    deleted: Option[IsCommentDeleted] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    callerReactions: Option[Iterable[ReactionValue]] = None,
    reactionCounts: Option[Map[ReactionValue, Count]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.Comment = {
    import Comment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.Comment
      .builder()
      .optionallyWith(
        commentId.map(value => CommentId.unwrap(value): java.lang.String)
      )(_.commentId)
      .optionallyWith(
        content.map(value => Content.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        inReplyTo.map(value => CommentId.unwrap(value): java.lang.String)
      )(_.inReplyTo)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => LastModifiedDate.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        authorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.authorArn)
      .optionallyWith(
        deleted.map(value => IsCommentDeleted.unwrap(value): java.lang.Boolean)
      )(_.deleted)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        callerReactions.map(value =>
          value.map { item =>
            ReactionValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.callerReactions)
      .optionallyWith(
        reactionCounts.map(value =>
          value
            .map({ case (key, value) =>
              (ReactionValue.unwrap(key): java.lang.String) -> (Count
                .unwrap(value): Integer)
            })
            .asJava
        )
      )(_.reactionCounts)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.Comment.ReadOnly =
    zio.aws.codecommit.model.Comment.wrap(buildAwsValue())
}
object Comment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.Comment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.Comment =
      zio.aws.codecommit.model.Comment(
        commentId.map(value => value),
        content.map(value => value),
        inReplyTo.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        authorArn.map(value => value),
        deleted.map(value => value),
        clientRequestToken.map(value => value),
        callerReactions.map(value => value),
        reactionCounts.map(value => value)
      )
    def commentId: Option[CommentId]
    def content: Option[Content]
    def inReplyTo: Option[CommentId]
    def creationDate: Option[CreationDate]
    def lastModifiedDate: Option[LastModifiedDate]
    def authorArn: Option[Arn]
    def deleted: Option[IsCommentDeleted]
    def clientRequestToken: Option[ClientRequestToken]
    def callerReactions: Option[List[ReactionValue]]
    def reactionCounts: Option[Map[ReactionValue, Count]]
    def getCommentId: ZIO[Any, AwsError, CommentId] =
      AwsError.unwrapOptionField("commentId", commentId)
    def getContent: ZIO[Any, AwsError, Content] =
      AwsError.unwrapOptionField("content", content)
    def getInReplyTo: ZIO[Any, AwsError, CommentId] =
      AwsError.unwrapOptionField("inReplyTo", inReplyTo)
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, LastModifiedDate] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getAuthorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("authorArn", authorArn)
    def getDeleted: ZIO[Any, AwsError, IsCommentDeleted] =
      AwsError.unwrapOptionField("deleted", deleted)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getCallerReactions: ZIO[Any, AwsError, List[ReactionValue]] =
      AwsError.unwrapOptionField("callerReactions", callerReactions)
    def getReactionCounts: ZIO[Any, AwsError, Map[ReactionValue, Count]] =
      AwsError.unwrapOptionField("reactionCounts", reactionCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.Comment
  ) extends zio.aws.codecommit.model.Comment.ReadOnly {
    override val commentId: Option[CommentId] = scala
      .Option(impl.commentId())
      .map(value => zio.aws.codecommit.model.primitives.CommentId(value))
    override val content: Option[Content] = scala
      .Option(impl.content())
      .map(value => zio.aws.codecommit.model.primitives.Content(value))
    override val inReplyTo: Option[CommentId] = scala
      .Option(impl.inReplyTo())
      .map(value => zio.aws.codecommit.model.primitives.CommentId(value))
    override val creationDate: Option[CreationDate] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.codecommit.model.primitives.CreationDate(value))
    override val lastModifiedDate: Option[LastModifiedDate] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.codecommit.model.primitives.LastModifiedDate(value))
    override val authorArn: Option[Arn] = scala
      .Option(impl.authorArn())
      .map(value => zio.aws.codecommit.model.primitives.Arn(value))
    override val deleted: Option[IsCommentDeleted] = scala
      .Option(impl.deleted())
      .map(value => zio.aws.codecommit.model.primitives.IsCommentDeleted(value))
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.codecommit.model.primitives.ClientRequestToken(value)
      )
    override val callerReactions: Option[List[ReactionValue]] = scala
      .Option(impl.callerReactions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.primitives.ReactionValue(item)
        }.toList
      )
    override val reactionCounts: Option[Map[ReactionValue, Count]] = scala
      .Option(impl.reactionCounts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codecommit.model.primitives.ReactionValue(
              key
            ) -> zio.aws.codecommit.model.primitives.Count(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.Comment
  ): zio.aws.codecommit.model.Comment.ReadOnly = new Wrapper(impl)
}
