package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.RepositoryTriggersConfigurationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutRepositoryTriggersResponse(
    configurationId: Option[RepositoryTriggersConfigurationId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PutRepositoryTriggersResponse = {
    import PutRepositoryTriggersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PutRepositoryTriggersResponse
      .builder()
      .optionallyWith(
        configurationId.map(value =>
          RepositoryTriggersConfigurationId.unwrap(value): java.lang.String
        )
      )(_.configurationId)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.PutRepositoryTriggersResponse.ReadOnly =
    zio.aws.codecommit.model.PutRepositoryTriggersResponse.wrap(buildAwsValue())
}
object PutRepositoryTriggersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PutRepositoryTriggersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.PutRepositoryTriggersResponse =
      zio.aws.codecommit.model
        .PutRepositoryTriggersResponse(configurationId.map(value => value))
    def configurationId: Option[RepositoryTriggersConfigurationId]
    def getConfigurationId
        : ZIO[Any, AwsError, RepositoryTriggersConfigurationId] =
      AwsError.unwrapOptionField("configurationId", configurationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PutRepositoryTriggersResponse
  ) extends zio.aws.codecommit.model.PutRepositoryTriggersResponse.ReadOnly {
    override val configurationId: Option[RepositoryTriggersConfigurationId] =
      scala
        .Option(impl.configurationId())
        .map(value =>
          zio.aws.codecommit.model.primitives
            .RepositoryTriggersConfigurationId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PutRepositoryTriggersResponse
  ): zio.aws.codecommit.model.PutRepositoryTriggersResponse.ReadOnly =
    new Wrapper(impl)
}
