package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.RepositoryId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteRepositoryResponse(
    repositoryId: Option[RepositoryId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.DeleteRepositoryResponse = {
    import DeleteRepositoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.DeleteRepositoryResponse
      .builder()
      .optionallyWith(
        repositoryId.map(value => RepositoryId.unwrap(value): java.lang.String)
      )(_.repositoryId)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.DeleteRepositoryResponse.ReadOnly =
    zio.aws.codecommit.model.DeleteRepositoryResponse.wrap(buildAwsValue())
}
object DeleteRepositoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.DeleteRepositoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.DeleteRepositoryResponse =
      zio.aws.codecommit.model
        .DeleteRepositoryResponse(repositoryId.map(value => value))
    def repositoryId: Option[RepositoryId]
    def getRepositoryId: ZIO[Any, AwsError, RepositoryId] =
      AwsError.unwrapOptionField("repositoryId", repositoryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteRepositoryResponse
  ) extends zio.aws.codecommit.model.DeleteRepositoryResponse.ReadOnly {
    override val repositoryId: Option[RepositoryId] = scala
      .Option(impl.repositoryId())
      .map(value => zio.aws.codecommit.model.primitives.RepositoryId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteRepositoryResponse
  ): zio.aws.codecommit.model.DeleteRepositoryResponse.ReadOnly = new Wrapper(
    impl
  )
}
