package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ObjectId,
  CommitId,
  RepositoryName,
  PullRequestId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CommentsForPullRequest(
    pullRequestId: Option[PullRequestId] = None,
    repositoryName: Option[RepositoryName] = None,
    beforeCommitId: Option[CommitId] = None,
    afterCommitId: Option[CommitId] = None,
    beforeBlobId: Option[ObjectId] = None,
    afterBlobId: Option[ObjectId] = None,
    location: Option[zio.aws.codecommit.model.Location] = None,
    comments: Option[Iterable[zio.aws.codecommit.model.Comment]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.CommentsForPullRequest = {
    import CommentsForPullRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.CommentsForPullRequest
      .builder()
      .optionallyWith(
        pullRequestId.map(value =>
          PullRequestId.unwrap(value): java.lang.String
        )
      )(_.pullRequestId)
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        beforeCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.beforeCommitId)
      .optionallyWith(
        afterCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.afterCommitId)
      .optionallyWith(
        beforeBlobId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.beforeBlobId)
      .optionallyWith(
        afterBlobId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.afterBlobId)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(
        comments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.comments)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.CommentsForPullRequest.ReadOnly =
    zio.aws.codecommit.model.CommentsForPullRequest.wrap(buildAwsValue())
}
object CommentsForPullRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.CommentsForPullRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.CommentsForPullRequest =
      zio.aws.codecommit.model.CommentsForPullRequest(
        pullRequestId.map(value => value),
        repositoryName.map(value => value),
        beforeCommitId.map(value => value),
        afterCommitId.map(value => value),
        beforeBlobId.map(value => value),
        afterBlobId.map(value => value),
        location.map(value => value.asEditable),
        comments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pullRequestId: Option[PullRequestId]
    def repositoryName: Option[RepositoryName]
    def beforeCommitId: Option[CommitId]
    def afterCommitId: Option[CommitId]
    def beforeBlobId: Option[ObjectId]
    def afterBlobId: Option[ObjectId]
    def location: Option[zio.aws.codecommit.model.Location.ReadOnly]
    def comments: Option[List[zio.aws.codecommit.model.Comment.ReadOnly]]
    def getPullRequestId: ZIO[Any, AwsError, PullRequestId] =
      AwsError.unwrapOptionField("pullRequestId", pullRequestId)
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getBeforeCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("beforeCommitId", beforeCommitId)
    def getAfterCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("afterCommitId", afterCommitId)
    def getBeforeBlobId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("beforeBlobId", beforeBlobId)
    def getAfterBlobId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("afterBlobId", afterBlobId)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.codecommit.model.Location.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getComments
        : ZIO[Any, AwsError, List[zio.aws.codecommit.model.Comment.ReadOnly]] =
      AwsError.unwrapOptionField("comments", comments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.CommentsForPullRequest
  ) extends zio.aws.codecommit.model.CommentsForPullRequest.ReadOnly {
    override val pullRequestId: Option[PullRequestId] = scala
      .Option(impl.pullRequestId())
      .map(value => zio.aws.codecommit.model.primitives.PullRequestId(value))
    override val repositoryName: Option[RepositoryName] = scala
      .Option(impl.repositoryName())
      .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val beforeCommitId: Option[CommitId] = scala
      .Option(impl.beforeCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val afterCommitId: Option[CommitId] = scala
      .Option(impl.afterCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val beforeBlobId: Option[ObjectId] = scala
      .Option(impl.beforeBlobId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val afterBlobId: Option[ObjectId] = scala
      .Option(impl.afterBlobId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val location: Option[zio.aws.codecommit.model.Location.ReadOnly] =
      scala
        .Option(impl.location())
        .map(value => zio.aws.codecommit.model.Location.wrap(value))
    override val comments
        : Option[List[zio.aws.codecommit.model.Comment.ReadOnly]] = scala
      .Option(impl.comments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.Comment.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.CommentsForPullRequest
  ): zio.aws.codecommit.model.CommentsForPullRequest.ReadOnly = new Wrapper(
    impl
  )
}
