package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ObjectTypes(
    source: Option[zio.aws.codecommit.model.ObjectTypeEnum] = None,
    destination: Option[zio.aws.codecommit.model.ObjectTypeEnum] = None,
    base: Option[zio.aws.codecommit.model.ObjectTypeEnum] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ObjectTypes = {
    import ObjectTypes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ObjectTypes
      .builder()
      .optionallyWith(source.map(value => value.unwrap))(_.source)
      .optionallyWith(destination.map(value => value.unwrap))(_.destination)
      .optionallyWith(base.map(value => value.unwrap))(_.base)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.ObjectTypes.ReadOnly =
    zio.aws.codecommit.model.ObjectTypes.wrap(buildAwsValue())
}
object ObjectTypes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ObjectTypes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ObjectTypes =
      zio.aws.codecommit.model.ObjectTypes(
        source.map(value => value),
        destination.map(value => value),
        base.map(value => value)
      )
    def source: Option[zio.aws.codecommit.model.ObjectTypeEnum]
    def destination: Option[zio.aws.codecommit.model.ObjectTypeEnum]
    def base: Option[zio.aws.codecommit.model.ObjectTypeEnum]
    def getSource: ZIO[Any, AwsError, zio.aws.codecommit.model.ObjectTypeEnum] =
      AwsError.unwrapOptionField("source", source)
    def getDestination
        : ZIO[Any, AwsError, zio.aws.codecommit.model.ObjectTypeEnum] =
      AwsError.unwrapOptionField("destination", destination)
    def getBase: ZIO[Any, AwsError, zio.aws.codecommit.model.ObjectTypeEnum] =
      AwsError.unwrapOptionField("base", base)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ObjectTypes
  ) extends zio.aws.codecommit.model.ObjectTypes.ReadOnly {
    override val source: Option[zio.aws.codecommit.model.ObjectTypeEnum] = scala
      .Option(impl.source())
      .map(value => zio.aws.codecommit.model.ObjectTypeEnum.wrap(value))
    override val destination: Option[zio.aws.codecommit.model.ObjectTypeEnum] =
      scala
        .Option(impl.destination())
        .map(value => zio.aws.codecommit.model.ObjectTypeEnum.wrap(value))
    override val base: Option[zio.aws.codecommit.model.ObjectTypeEnum] = scala
      .Option(impl.base())
      .map(value => zio.aws.codecommit.model.ObjectTypeEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ObjectTypes
  ): zio.aws.codecommit.model.ObjectTypes.ReadOnly = new Wrapper(impl)
}
