package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{CommitId, RepositoryName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PullRequestSourceReferenceUpdatedEventMetadata(
    repositoryName: Option[RepositoryName] = None,
    beforeCommitId: Option[CommitId] = None,
    afterCommitId: Option[CommitId] = None,
    mergeBase: Option[CommitId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata = {
    import PullRequestSourceReferenceUpdatedEventMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata
      .builder()
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        beforeCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.beforeCommitId)
      .optionallyWith(
        afterCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.afterCommitId)
      .optionallyWith(
        mergeBase.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.mergeBase)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata.ReadOnly =
    zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata
      .wrap(buildAwsValue())
}
object PullRequestSourceReferenceUpdatedEventMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata =
      zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata(
        repositoryName.map(value => value),
        beforeCommitId.map(value => value),
        afterCommitId.map(value => value),
        mergeBase.map(value => value)
      )
    def repositoryName: Option[RepositoryName]
    def beforeCommitId: Option[CommitId]
    def afterCommitId: Option[CommitId]
    def mergeBase: Option[CommitId]
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getBeforeCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("beforeCommitId", beforeCommitId)
    def getAfterCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("afterCommitId", afterCommitId)
    def getMergeBase: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("mergeBase", mergeBase)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata
  ) extends zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata.ReadOnly {
    override val repositoryName: Option[RepositoryName] = scala
      .Option(impl.repositoryName())
      .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val beforeCommitId: Option[CommitId] = scala
      .Option(impl.beforeCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val afterCommitId: Option[CommitId] = scala
      .Option(impl.afterCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val mergeBase: Option[CommitId] = scala
      .Option(impl.mergeBase())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata
  ): zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata.ReadOnly =
    new Wrapper(impl)
}
