package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MergePullRequestBySquashResponse(
    pullRequest: Option[zio.aws.codecommit.model.PullRequest] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashResponse = {
    import MergePullRequestBySquashResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashResponse
      .builder()
      .optionallyWith(pullRequest.map(value => value.buildAwsValue()))(
        _.pullRequest
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.MergePullRequestBySquashResponse.ReadOnly =
    zio.aws.codecommit.model.MergePullRequestBySquashResponse
      .wrap(buildAwsValue())
}
object MergePullRequestBySquashResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.MergePullRequestBySquashResponse =
      zio.aws.codecommit.model.MergePullRequestBySquashResponse(
        pullRequest.map(value => value.asEditable)
      )
    def pullRequest: Option[zio.aws.codecommit.model.PullRequest.ReadOnly]
    def getPullRequest
        : ZIO[Any, AwsError, zio.aws.codecommit.model.PullRequest.ReadOnly] =
      AwsError.unwrapOptionField("pullRequest", pullRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashResponse
  ) extends zio.aws.codecommit.model.MergePullRequestBySquashResponse.ReadOnly {
    override val pullRequest
        : Option[zio.aws.codecommit.model.PullRequest.ReadOnly] = scala
      .Option(impl.pullRequest())
      .map(value => zio.aws.codecommit.model.PullRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashResponse
  ): zio.aws.codecommit.model.MergePullRequestBySquashResponse.ReadOnly =
    new Wrapper(impl)
}
