package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{MaxResults, NextToken}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListApprovalRuleTemplatesRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesRequest = {
    import ListApprovalRuleTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.ListApprovalRuleTemplatesRequest.ReadOnly =
    zio.aws.codecommit.model.ListApprovalRuleTemplatesRequest
      .wrap(buildAwsValue())
}
object ListApprovalRuleTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ListApprovalRuleTemplatesRequest =
      zio.aws.codecommit.model.ListApprovalRuleTemplatesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesRequest
  ) extends zio.aws.codecommit.model.ListApprovalRuleTemplatesRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codecommit.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesRequest
  ): zio.aws.codecommit.model.ListApprovalRuleTemplatesRequest.ReadOnly =
    new Wrapper(impl)
}
