package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteBranchResponse(
    deletedBranch: Option[zio.aws.codecommit.model.BranchInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.DeleteBranchResponse = {
    import DeleteBranchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.DeleteBranchResponse
      .builder()
      .optionallyWith(deletedBranch.map(value => value.buildAwsValue()))(
        _.deletedBranch
      )
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.DeleteBranchResponse.ReadOnly =
    zio.aws.codecommit.model.DeleteBranchResponse.wrap(buildAwsValue())
}
object DeleteBranchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.DeleteBranchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.DeleteBranchResponse =
      zio.aws.codecommit.model
        .DeleteBranchResponse(deletedBranch.map(value => value.asEditable))
    def deletedBranch: Option[zio.aws.codecommit.model.BranchInfo.ReadOnly]
    def getDeletedBranch
        : ZIO[Any, AwsError, zio.aws.codecommit.model.BranchInfo.ReadOnly] =
      AwsError.unwrapOptionField("deletedBranch", deletedBranch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteBranchResponse
  ) extends zio.aws.codecommit.model.DeleteBranchResponse.ReadOnly {
    override val deletedBranch
        : Option[zio.aws.codecommit.model.BranchInfo.ReadOnly] = scala
      .Option(impl.deletedBranch())
      .map(value => zio.aws.codecommit.model.BranchInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteBranchResponse
  ): zio.aws.codecommit.model.DeleteBranchResponse.ReadOnly = new Wrapper(impl)
}
