package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  KeepEmptyFolders,
  Message,
  RepositoryName,
  PullRequestId,
  Email,
  ObjectId,
  Name
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MergePullRequestBySquashRequest(
    pullRequestId: PullRequestId,
    repositoryName: RepositoryName,
    sourceCommitId: Option[ObjectId] = None,
    conflictDetailLevel: Option[
      zio.aws.codecommit.model.ConflictDetailLevelTypeEnum
    ] = None,
    conflictResolutionStrategy: Option[
      zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
    ] = None,
    commitMessage: Option[Message] = None,
    authorName: Option[Name] = None,
    email: Option[Email] = None,
    keepEmptyFolders: Option[KeepEmptyFolders] = None,
    conflictResolution: Option[zio.aws.codecommit.model.ConflictResolution] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashRequest = {
    import MergePullRequestBySquashRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashRequest
      .builder()
      .pullRequestId(PullRequestId.unwrap(pullRequestId): java.lang.String)
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .optionallyWith(
        sourceCommitId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.sourceCommitId)
      .optionallyWith(conflictDetailLevel.map(value => value.unwrap))(
        _.conflictDetailLevel
      )
      .optionallyWith(conflictResolutionStrategy.map(value => value.unwrap))(
        _.conflictResolutionStrategy
      )
      .optionallyWith(
        commitMessage.map(value => Message.unwrap(value): java.lang.String)
      )(_.commitMessage)
      .optionallyWith(
        authorName.map(value => Name.unwrap(value): java.lang.String)
      )(_.authorName)
      .optionallyWith(
        email.map(value => Email.unwrap(value): java.lang.String)
      )(_.email)
      .optionallyWith(
        keepEmptyFolders.map(value =>
          KeepEmptyFolders.unwrap(value): java.lang.Boolean
        )
      )(_.keepEmptyFolders)
      .optionallyWith(conflictResolution.map(value => value.buildAwsValue()))(
        _.conflictResolution
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.MergePullRequestBySquashRequest.ReadOnly =
    zio.aws.codecommit.model.MergePullRequestBySquashRequest
      .wrap(buildAwsValue())
}
object MergePullRequestBySquashRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.MergePullRequestBySquashRequest =
      zio.aws.codecommit.model.MergePullRequestBySquashRequest(
        pullRequestId,
        repositoryName,
        sourceCommitId.map(value => value),
        conflictDetailLevel.map(value => value),
        conflictResolutionStrategy.map(value => value),
        commitMessage.map(value => value),
        authorName.map(value => value),
        email.map(value => value),
        keepEmptyFolders.map(value => value),
        conflictResolution.map(value => value.asEditable)
      )
    def pullRequestId: PullRequestId
    def repositoryName: RepositoryName
    def sourceCommitId: Option[ObjectId]
    def conflictDetailLevel
        : Option[zio.aws.codecommit.model.ConflictDetailLevelTypeEnum]
    def conflictResolutionStrategy
        : Option[zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum]
    def commitMessage: Option[Message]
    def authorName: Option[Name]
    def email: Option[Email]
    def keepEmptyFolders: Option[KeepEmptyFolders]
    def conflictResolution
        : Option[zio.aws.codecommit.model.ConflictResolution.ReadOnly]
    def getPullRequestId: ZIO[Any, Nothing, PullRequestId] =
      ZIO.succeed(pullRequestId)
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getSourceCommitId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("sourceCommitId", sourceCommitId)
    def getConflictDetailLevel: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ConflictDetailLevelTypeEnum
    ] = AwsError.unwrapOptionField("conflictDetailLevel", conflictDetailLevel)
    def getConflictResolutionStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
    ] = AwsError.unwrapOptionField(
      "conflictResolutionStrategy",
      conflictResolutionStrategy
    )
    def getCommitMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("commitMessage", commitMessage)
    def getAuthorName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("authorName", authorName)
    def getEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("email", email)
    def getKeepEmptyFolders: ZIO[Any, AwsError, KeepEmptyFolders] =
      AwsError.unwrapOptionField("keepEmptyFolders", keepEmptyFolders)
    def getConflictResolution: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ConflictResolution.ReadOnly
    ] = AwsError.unwrapOptionField("conflictResolution", conflictResolution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashRequest
  ) extends zio.aws.codecommit.model.MergePullRequestBySquashRequest.ReadOnly {
    override val pullRequestId: PullRequestId =
      zio.aws.codecommit.model.primitives.PullRequestId(impl.pullRequestId())
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val sourceCommitId: Option[ObjectId] = scala
      .Option(impl.sourceCommitId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val conflictDetailLevel
        : Option[zio.aws.codecommit.model.ConflictDetailLevelTypeEnum] = scala
      .Option(impl.conflictDetailLevel())
      .map(value =>
        zio.aws.codecommit.model.ConflictDetailLevelTypeEnum.wrap(value)
      )
    override val conflictResolutionStrategy
        : Option[zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum] =
      scala
        .Option(impl.conflictResolutionStrategy())
        .map(value =>
          zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
            .wrap(value)
        )
    override val commitMessage: Option[Message] = scala
      .Option(impl.commitMessage())
      .map(value => zio.aws.codecommit.model.primitives.Message(value))
    override val authorName: Option[Name] = scala
      .Option(impl.authorName())
      .map(value => zio.aws.codecommit.model.primitives.Name(value))
    override val email: Option[Email] = scala
      .Option(impl.email())
      .map(value => zio.aws.codecommit.model.primitives.Email(value))
    override val keepEmptyFolders: Option[KeepEmptyFolders] = scala
      .Option(impl.keepEmptyFolders())
      .map(value => zio.aws.codecommit.model.primitives.KeepEmptyFolders(value))
    override val conflictResolution
        : Option[zio.aws.codecommit.model.ConflictResolution.ReadOnly] = scala
      .Option(impl.conflictResolution())
      .map(value => zio.aws.codecommit.model.ConflictResolution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashRequest
  ): zio.aws.codecommit.model.MergePullRequestBySquashRequest.ReadOnly =
    new Wrapper(impl)
}
