package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  FileContent,
  CommitId,
  Message,
  RepositoryName,
  Email,
  Path,
  Name,
  BranchName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutFileRequest(
    repositoryName: RepositoryName,
    branchName: BranchName,
    fileContent: FileContent,
    filePath: Path,
    fileMode: Option[zio.aws.codecommit.model.FileModeTypeEnum] = None,
    parentCommitId: Option[CommitId] = None,
    commitMessage: Option[Message] = None,
    name: Option[Name] = None,
    email: Option[Email] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PutFileRequest = {
    import PutFileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PutFileRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .fileContent(
        software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
          fileContent.toArray[Byte]
        )
      )
      .filePath(Path.unwrap(filePath): java.lang.String)
      .optionallyWith(fileMode.map(value => value.unwrap))(_.fileMode)
      .optionallyWith(
        parentCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.parentCommitId)
      .optionallyWith(
        commitMessage.map(value => Message.unwrap(value): java.lang.String)
      )(_.commitMessage)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        email.map(value => Email.unwrap(value): java.lang.String)
      )(_.email)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.PutFileRequest.ReadOnly =
    zio.aws.codecommit.model.PutFileRequest.wrap(buildAwsValue())
}
object PutFileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PutFileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.PutFileRequest =
      zio.aws.codecommit.model.PutFileRequest(
        repositoryName,
        branchName,
        fileContent,
        filePath,
        fileMode.map(value => value),
        parentCommitId.map(value => value),
        commitMessage.map(value => value),
        name.map(value => value),
        email.map(value => value)
      )
    def repositoryName: RepositoryName
    def branchName: BranchName
    def fileContent: FileContent
    def filePath: Path
    def fileMode: Option[zio.aws.codecommit.model.FileModeTypeEnum]
    def parentCommitId: Option[CommitId]
    def commitMessage: Option[Message]
    def name: Option[Name]
    def email: Option[Email]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
    def getFileContent: ZIO[Any, Nothing, FileContent] =
      ZIO.succeed(fileContent)
    def getFilePath: ZIO[Any, Nothing, Path] = ZIO.succeed(filePath)
    def getFileMode
        : ZIO[Any, AwsError, zio.aws.codecommit.model.FileModeTypeEnum] =
      AwsError.unwrapOptionField("fileMode", fileMode)
    def getParentCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("parentCommitId", parentCommitId)
    def getCommitMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("commitMessage", commitMessage)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("email", email)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PutFileRequest
  ) extends zio.aws.codecommit.model.PutFileRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val branchName: BranchName =
      zio.aws.codecommit.model.primitives.BranchName(impl.branchName())
    override val fileContent: FileContent = zio.aws.codecommit.model.primitives
      .FileContent(zio.Chunk.fromArray(impl.fileContent().asByteArrayUnsafe()))
    override val filePath: Path =
      zio.aws.codecommit.model.primitives.Path(impl.filePath())
    override val fileMode: Option[zio.aws.codecommit.model.FileModeTypeEnum] =
      scala
        .Option(impl.fileMode())
        .map(value => zio.aws.codecommit.model.FileModeTypeEnum.wrap(value))
    override val parentCommitId: Option[CommitId] = scala
      .Option(impl.parentCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val commitMessage: Option[Message] = scala
      .Option(impl.commitMessage())
      .map(value => zio.aws.codecommit.model.primitives.Message(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.codecommit.model.primitives.Name(value))
    override val email: Option[Email] = scala
      .Option(impl.email())
      .map(value => zio.aws.codecommit.model.primitives.Email(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PutFileRequest
  ): zio.aws.codecommit.model.PutFileRequest.ReadOnly = new Wrapper(impl)
}
