package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Conflict(
    conflictMetadata: Option[zio.aws.codecommit.model.ConflictMetadata] = None,
    mergeHunks: Option[Iterable[zio.aws.codecommit.model.MergeHunk]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.Conflict = {
    import Conflict.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.Conflict
      .builder()
      .optionallyWith(conflictMetadata.map(value => value.buildAwsValue()))(
        _.conflictMetadata
      )
      .optionallyWith(
        mergeHunks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mergeHunks)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.Conflict.ReadOnly =
    zio.aws.codecommit.model.Conflict.wrap(buildAwsValue())
}
object Conflict {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.Conflict
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.Conflict =
      zio.aws.codecommit.model.Conflict(
        conflictMetadata.map(value => value.asEditable),
        mergeHunks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def conflictMetadata
        : Option[zio.aws.codecommit.model.ConflictMetadata.ReadOnly]
    def mergeHunks: Option[List[zio.aws.codecommit.model.MergeHunk.ReadOnly]]
    def getConflictMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ConflictMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("conflictMetadata", conflictMetadata)
    def getMergeHunks: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.MergeHunk.ReadOnly
    ]] = AwsError.unwrapOptionField("mergeHunks", mergeHunks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.Conflict
  ) extends zio.aws.codecommit.model.Conflict.ReadOnly {
    override val conflictMetadata
        : Option[zio.aws.codecommit.model.ConflictMetadata.ReadOnly] = scala
      .Option(impl.conflictMetadata())
      .map(value => zio.aws.codecommit.model.ConflictMetadata.wrap(value))
    override val mergeHunks
        : Option[List[zio.aws.codecommit.model.MergeHunk.ReadOnly]] = scala
      .Option(impl.mergeHunks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.MergeHunk.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.Conflict
  ): zio.aws.codecommit.model.Conflict.ReadOnly = new Wrapper(impl)
}
