package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  CommitName,
  NextToken,
  RepositoryName,
  MaxResults,
  Path
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeMergeConflictsRequest(
    repositoryName: RepositoryName,
    destinationCommitSpecifier: CommitName,
    sourceCommitSpecifier: CommitName,
    mergeOption: zio.aws.codecommit.model.MergeOptionTypeEnum,
    maxMergeHunks: Option[MaxResults] = None,
    filePath: Path,
    conflictDetailLevel: Option[
      zio.aws.codecommit.model.ConflictDetailLevelTypeEnum
    ] = None,
    conflictResolutionStrategy: Option[
      zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest = {
    import DescribeMergeConflictsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .destinationCommitSpecifier(
        CommitName.unwrap(destinationCommitSpecifier): java.lang.String
      )
      .sourceCommitSpecifier(
        CommitName.unwrap(sourceCommitSpecifier): java.lang.String
      )
      .mergeOption(mergeOption.unwrap)
      .optionallyWith(
        maxMergeHunks.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxMergeHunks)
      .filePath(Path.unwrap(filePath): java.lang.String)
      .optionallyWith(conflictDetailLevel.map(value => value.unwrap))(
        _.conflictDetailLevel
      )
      .optionallyWith(conflictResolutionStrategy.map(value => value.unwrap))(
        _.conflictResolutionStrategy
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.DescribeMergeConflictsRequest.ReadOnly =
    zio.aws.codecommit.model.DescribeMergeConflictsRequest.wrap(buildAwsValue())
}
object DescribeMergeConflictsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.DescribeMergeConflictsRequest =
      zio.aws.codecommit.model.DescribeMergeConflictsRequest(
        repositoryName,
        destinationCommitSpecifier,
        sourceCommitSpecifier,
        mergeOption,
        maxMergeHunks.map(value => value),
        filePath,
        conflictDetailLevel.map(value => value),
        conflictResolutionStrategy.map(value => value),
        nextToken.map(value => value)
      )
    def repositoryName: RepositoryName
    def destinationCommitSpecifier: CommitName
    def sourceCommitSpecifier: CommitName
    def mergeOption: zio.aws.codecommit.model.MergeOptionTypeEnum
    def maxMergeHunks: Option[MaxResults]
    def filePath: Path
    def conflictDetailLevel
        : Option[zio.aws.codecommit.model.ConflictDetailLevelTypeEnum]
    def conflictResolutionStrategy
        : Option[zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum]
    def nextToken: Option[NextToken]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getDestinationCommitSpecifier: ZIO[Any, Nothing, CommitName] =
      ZIO.succeed(destinationCommitSpecifier)
    def getSourceCommitSpecifier: ZIO[Any, Nothing, CommitName] =
      ZIO.succeed(sourceCommitSpecifier)
    def getMergeOption
        : ZIO[Any, Nothing, zio.aws.codecommit.model.MergeOptionTypeEnum] =
      ZIO.succeed(mergeOption)
    def getMaxMergeHunks: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxMergeHunks", maxMergeHunks)
    def getFilePath: ZIO[Any, Nothing, Path] = ZIO.succeed(filePath)
    def getConflictDetailLevel: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ConflictDetailLevelTypeEnum
    ] = AwsError.unwrapOptionField("conflictDetailLevel", conflictDetailLevel)
    def getConflictResolutionStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
    ] = AwsError.unwrapOptionField(
      "conflictResolutionStrategy",
      conflictResolutionStrategy
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest
  ) extends zio.aws.codecommit.model.DescribeMergeConflictsRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val destinationCommitSpecifier: CommitName =
      zio.aws.codecommit.model.primitives
        .CommitName(impl.destinationCommitSpecifier())
    override val sourceCommitSpecifier: CommitName =
      zio.aws.codecommit.model.primitives
        .CommitName(impl.sourceCommitSpecifier())
    override val mergeOption: zio.aws.codecommit.model.MergeOptionTypeEnum =
      zio.aws.codecommit.model.MergeOptionTypeEnum.wrap(impl.mergeOption())
    override val maxMergeHunks: Option[MaxResults] = scala
      .Option(impl.maxMergeHunks())
      .map(value => zio.aws.codecommit.model.primitives.MaxResults(value))
    override val filePath: Path =
      zio.aws.codecommit.model.primitives.Path(impl.filePath())
    override val conflictDetailLevel
        : Option[zio.aws.codecommit.model.ConflictDetailLevelTypeEnum] = scala
      .Option(impl.conflictDetailLevel())
      .map(value =>
        zio.aws.codecommit.model.ConflictDetailLevelTypeEnum.wrap(value)
      )
    override val conflictResolutionStrategy
        : Option[zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum] =
      scala
        .Option(impl.conflictResolutionStrategy())
        .map(value =>
          zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
            .wrap(value)
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest
  ): zio.aws.codecommit.model.DescribeMergeConflictsRequest.ReadOnly =
    new Wrapper(impl)
}
