package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ApprovalRuleTemplateId,
  ApprovalRuleTemplateContent,
  ApprovalRuleTemplateName,
  Arn,
  ApprovalRuleTemplateDescription,
  LastModifiedDate,
  RuleContentSha256,
  CreationDate
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ApprovalRuleTemplate(
    approvalRuleTemplateId: Option[ApprovalRuleTemplateId] = None,
    approvalRuleTemplateName: Option[ApprovalRuleTemplateName] = None,
    approvalRuleTemplateDescription: Option[ApprovalRuleTemplateDescription] =
      None,
    approvalRuleTemplateContent: Option[ApprovalRuleTemplateContent] = None,
    ruleContentSha256: Option[RuleContentSha256] = None,
    lastModifiedDate: Option[LastModifiedDate] = None,
    creationDate: Option[CreationDate] = None,
    lastModifiedUser: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplate = {
    import ApprovalRuleTemplate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplate
      .builder()
      .optionallyWith(
        approvalRuleTemplateId.map(value =>
          ApprovalRuleTemplateId.unwrap(value): java.lang.String
        )
      )(_.approvalRuleTemplateId)
      .optionallyWith(
        approvalRuleTemplateName.map(value =>
          ApprovalRuleTemplateName.unwrap(value): java.lang.String
        )
      )(_.approvalRuleTemplateName)
      .optionallyWith(
        approvalRuleTemplateDescription.map(value =>
          ApprovalRuleTemplateDescription.unwrap(value): java.lang.String
        )
      )(_.approvalRuleTemplateDescription)
      .optionallyWith(
        approvalRuleTemplateContent.map(value =>
          ApprovalRuleTemplateContent.unwrap(value): java.lang.String
        )
      )(_.approvalRuleTemplateContent)
      .optionallyWith(
        ruleContentSha256.map(value =>
          RuleContentSha256.unwrap(value): java.lang.String
        )
      )(_.ruleContentSha256)
      .optionallyWith(
        lastModifiedDate.map(value => LastModifiedDate.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedUser.map(value => Arn.unwrap(value): java.lang.String)
      )(_.lastModifiedUser)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.ApprovalRuleTemplate.ReadOnly =
    zio.aws.codecommit.model.ApprovalRuleTemplate.wrap(buildAwsValue())
}
object ApprovalRuleTemplate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ApprovalRuleTemplate =
      zio.aws.codecommit.model.ApprovalRuleTemplate(
        approvalRuleTemplateId.map(value => value),
        approvalRuleTemplateName.map(value => value),
        approvalRuleTemplateDescription.map(value => value),
        approvalRuleTemplateContent.map(value => value),
        ruleContentSha256.map(value => value),
        lastModifiedDate.map(value => value),
        creationDate.map(value => value),
        lastModifiedUser.map(value => value)
      )
    def approvalRuleTemplateId: Option[ApprovalRuleTemplateId]
    def approvalRuleTemplateName: Option[ApprovalRuleTemplateName]
    def approvalRuleTemplateDescription: Option[ApprovalRuleTemplateDescription]
    def approvalRuleTemplateContent: Option[ApprovalRuleTemplateContent]
    def ruleContentSha256: Option[RuleContentSha256]
    def lastModifiedDate: Option[LastModifiedDate]
    def creationDate: Option[CreationDate]
    def lastModifiedUser: Option[Arn]
    def getApprovalRuleTemplateId: ZIO[Any, AwsError, ApprovalRuleTemplateId] =
      AwsError.unwrapOptionField(
        "approvalRuleTemplateId",
        approvalRuleTemplateId
      )
    def getApprovalRuleTemplateName
        : ZIO[Any, AwsError, ApprovalRuleTemplateName] = AwsError
      .unwrapOptionField("approvalRuleTemplateName", approvalRuleTemplateName)
    def getApprovalRuleTemplateDescription
        : ZIO[Any, AwsError, ApprovalRuleTemplateDescription] =
      AwsError.unwrapOptionField(
        "approvalRuleTemplateDescription",
        approvalRuleTemplateDescription
      )
    def getApprovalRuleTemplateContent
        : ZIO[Any, AwsError, ApprovalRuleTemplateContent] =
      AwsError.unwrapOptionField(
        "approvalRuleTemplateContent",
        approvalRuleTemplateContent
      )
    def getRuleContentSha256: ZIO[Any, AwsError, RuleContentSha256] =
      AwsError.unwrapOptionField("ruleContentSha256", ruleContentSha256)
    def getLastModifiedDate: ZIO[Any, AwsError, LastModifiedDate] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedUser: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("lastModifiedUser", lastModifiedUser)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplate
  ) extends zio.aws.codecommit.model.ApprovalRuleTemplate.ReadOnly {
    override val approvalRuleTemplateId: Option[ApprovalRuleTemplateId] = scala
      .Option(impl.approvalRuleTemplateId())
      .map(value =>
        zio.aws.codecommit.model.primitives.ApprovalRuleTemplateId(value)
      )
    override val approvalRuleTemplateName: Option[ApprovalRuleTemplateName] =
      scala
        .Option(impl.approvalRuleTemplateName())
        .map(value =>
          zio.aws.codecommit.model.primitives.ApprovalRuleTemplateName(value)
        )
    override val approvalRuleTemplateDescription
        : Option[ApprovalRuleTemplateDescription] = scala
      .Option(impl.approvalRuleTemplateDescription())
      .map(value =>
        zio.aws.codecommit.model.primitives
          .ApprovalRuleTemplateDescription(value)
      )
    override val approvalRuleTemplateContent
        : Option[ApprovalRuleTemplateContent] = scala
      .Option(impl.approvalRuleTemplateContent())
      .map(value =>
        zio.aws.codecommit.model.primitives.ApprovalRuleTemplateContent(value)
      )
    override val ruleContentSha256: Option[RuleContentSha256] = scala
      .Option(impl.ruleContentSha256())
      .map(value =>
        zio.aws.codecommit.model.primitives.RuleContentSha256(value)
      )
    override val lastModifiedDate: Option[LastModifiedDate] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.codecommit.model.primitives.LastModifiedDate(value))
    override val creationDate: Option[CreationDate] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.codecommit.model.primitives.CreationDate(value))
    override val lastModifiedUser: Option[Arn] = scala
      .Option(impl.lastModifiedUser())
      .map(value => zio.aws.codecommit.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplate
  ): zio.aws.codecommit.model.ApprovalRuleTemplate.ReadOnly = new Wrapper(impl)
}
