package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MergeOperations(
    source: Option[zio.aws.codecommit.model.ChangeTypeEnum] = None,
    destination: Option[zio.aws.codecommit.model.ChangeTypeEnum] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.MergeOperations = {
    import MergeOperations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.MergeOperations
      .builder()
      .optionallyWith(source.map(value => value.unwrap))(_.source)
      .optionallyWith(destination.map(value => value.unwrap))(_.destination)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.MergeOperations.ReadOnly =
    zio.aws.codecommit.model.MergeOperations.wrap(buildAwsValue())
}
object MergeOperations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.MergeOperations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.MergeOperations =
      zio.aws.codecommit.model.MergeOperations(
        source.map(value => value),
        destination.map(value => value)
      )
    def source: Option[zio.aws.codecommit.model.ChangeTypeEnum]
    def destination: Option[zio.aws.codecommit.model.ChangeTypeEnum]
    def getSource: ZIO[Any, AwsError, zio.aws.codecommit.model.ChangeTypeEnum] =
      AwsError.unwrapOptionField("source", source)
    def getDestination
        : ZIO[Any, AwsError, zio.aws.codecommit.model.ChangeTypeEnum] =
      AwsError.unwrapOptionField("destination", destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.MergeOperations
  ) extends zio.aws.codecommit.model.MergeOperations.ReadOnly {
    override val source: Option[zio.aws.codecommit.model.ChangeTypeEnum] = scala
      .Option(impl.source())
      .map(value => zio.aws.codecommit.model.ChangeTypeEnum.wrap(value))
    override val destination: Option[zio.aws.codecommit.model.ChangeTypeEnum] =
      scala
        .Option(impl.destination())
        .map(value => zio.aws.codecommit.model.ChangeTypeEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.MergeOperations
  ): zio.aws.codecommit.model.MergeOperations.ReadOnly = new Wrapper(impl)
}
