package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{ReferenceName, RepositoryName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Target(
    repositoryName: RepositoryName,
    sourceReference: ReferenceName,
    destinationReference: Option[ReferenceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.Target = {
    import Target.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.Target
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .sourceReference(ReferenceName.unwrap(sourceReference): java.lang.String)
      .optionallyWith(
        destinationReference.map(value =>
          ReferenceName.unwrap(value): java.lang.String
        )
      )(_.destinationReference)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.Target.ReadOnly =
    zio.aws.codecommit.model.Target.wrap(buildAwsValue())
}
object Target {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.codecommit.model.Target] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.Target =
      zio.aws.codecommit.model.Target(
        repositoryName,
        sourceReference,
        destinationReference.map(value => value)
      )
    def repositoryName: RepositoryName
    def sourceReference: ReferenceName
    def destinationReference: Option[ReferenceName]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getSourceReference: ZIO[Any, Nothing, ReferenceName] =
      ZIO.succeed(sourceReference)
    def getDestinationReference: ZIO[Any, AwsError, ReferenceName] =
      AwsError.unwrapOptionField("destinationReference", destinationReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.Target
  ) extends zio.aws.codecommit.model.Target.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val sourceReference: ReferenceName =
      zio.aws.codecommit.model.primitives.ReferenceName(impl.sourceReference())
    override val destinationReference: Option[ReferenceName] = scala
      .Option(impl.destinationReference())
      .map(value => zio.aws.codecommit.model.primitives.ReferenceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.Target
  ): zio.aws.codecommit.model.Target.ReadOnly = new Wrapper(impl)
}
