package zio.aws.codecommit
import zio.aws.codecommit.model.GetFileResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.codecommit.paginators.{
  ListRepositoriesPublisher,
  ListBranchesPublisher
}
import software.amazon.awssdk.services.codecommit.model.{
  GetBranchResponse,
  BatchAssociateApprovalRuleTemplateWithRepositoriesRequest,
  GetMergeOptionsResponse,
  DisassociateApprovalRuleTemplateFromRepositoryResponse,
  DeleteFileRequest,
  ListBranchesResponse,
  UpdateApprovalRuleTemplateContentResponse,
  GetCommentsForPullRequestResponse,
  GetBlobRequest,
  UpdatePullRequestApprovalStateResponse,
  MergeBranchesBySquashRequest,
  ListApprovalRuleTemplatesRequest,
  ListPullRequestsRequest,
  GetPullRequestApprovalStatesRequest,
  EvaluatePullRequestApprovalRulesResponse,
  UpdatePullRequestApprovalStateRequest,
  PutRepositoryTriggersRequest,
  OverridePullRequestApprovalRulesResponse,
  DeleteRepositoryResponse,
  CreateApprovalRuleTemplateRequest,
  GetCommentsForPullRequestRequest,
  ListRepositoriesResponse,
  OverridePullRequestApprovalRulesRequest,
  GetPullRequestResponse,
  CreateRepositoryResponse,
  GetCommentResponse,
  GetCommitResponse,
  UpdateRepositoryNameResponse,
  GetCommentReactionsRequest,
  MergeBranchesByFastForwardResponse,
  GetCommentsForComparedCommitResponse,
  GetCommitRequest,
  Difference,
  RepositoryNameIdPair,
  GetRepositoryResponse,
  DeletePullRequestApprovalRuleResponse,
  DescribeMergeConflictsRequest,
  UpdateDefaultBranchRequest,
  PutCommentReactionResponse,
  DeleteCommentContentRequest,
  PostCommentReplyResponse,
  GetRepositoryTriggersRequest,
  GetCommentReactionsResponse,
  UpdateApprovalRuleTemplateDescriptionRequest,
  UpdatePullRequestDescriptionResponse,
  GetBlobResponse,
  UpdatePullRequestApprovalRuleContentResponse,
  GetBranchRequest,
  DeleteCommentContentResponse,
  AssociateApprovalRuleTemplateWithRepositoryResponse,
  PutFileResponse,
  PostCommentForPullRequestRequest,
  ListTagsForResourceRequest,
  UpdatePullRequestStatusRequest,
  GetFolderResponse,
  UpdateApprovalRuleTemplateContentRequest,
  TestRepositoryTriggersRequest,
  MergePullRequestBySquashRequest,
  UpdateApprovalRuleTemplateNameResponse,
  UpdateCommentResponse,
  GetMergeConflictsRequest,
  GetPullRequestOverrideStateRequest,
  ListRepositoriesForApprovalRuleTemplateRequest,
  DeleteApprovalRuleTemplateResponse,
  GetDifferencesRequest,
  DeletePullRequestApprovalRuleRequest,
  CreatePullRequestApprovalRuleRequest,
  DisassociateApprovalRuleTemplateFromRepositoryRequest,
  CreateRepositoryRequest,
  CreateBranchRequest,
  ListTagsForResourceResponse,
  BatchGetRepositoriesRequest,
  TestRepositoryTriggersResponse,
  ListRepositoriesForApprovalRuleTemplateResponse,
  UntagResourceResponse,
  GetApprovalRuleTemplateResponse,
  DescribeMergeConflictsResponse,
  PostCommentReplyRequest,
  DeleteBranchResponse,
  UpdateRepositoryDescriptionResponse,
  CreateUnreferencedMergeCommitRequest,
  AssociateApprovalRuleTemplateWithRepositoryRequest,
  GetFolderRequest,
  MergeBranchesByThreeWayRequest,
  MergePullRequestByThreeWayRequest,
  UpdateRepositoryNameRequest,
  ListAssociatedApprovalRuleTemplatesForRepositoryResponse,
  PostCommentForComparedCommitResponse,
  DescribePullRequestEventsResponse,
  UpdateRepositoryDescriptionRequest,
  BatchGetRepositoriesResponse,
  BatchDescribeMergeConflictsResponse,
  BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse,
  GetCommentRequest,
  GetFileResponse,
  CreatePullRequestResponse,
  GetPullRequestApprovalStatesResponse,
  PostCommentForPullRequestResponse,
  GetPullRequestOverrideStateResponse,
  ListPullRequestsResponse,
  MergeBranchesByThreeWayResponse,
  BatchDescribeMergeConflictsRequest,
  GetFileRequest,
  CreateUnreferencedMergeCommitResponse,
  UntagResourceRequest,
  ListRepositoriesRequest,
  ListBranchesRequest,
  EvaluatePullRequestApprovalRulesRequest,
  BatchGetCommitsResponse,
  CreateCommitRequest,
  DescribePullRequestEventsRequest,
  UpdateCommentRequest,
  UpdatePullRequestDescriptionRequest,
  PostCommentForComparedCommitRequest,
  BatchGetCommitsRequest,
  BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest,
  GetPullRequestRequest,
  PutCommentReactionRequest,
  UpdatePullRequestApprovalRuleContentRequest,
  DeleteApprovalRuleTemplateRequest,
  GetDifferencesResponse,
  UpdatePullRequestTitleResponse,
  MergePullRequestByFastForwardResponse,
  DeleteRepositoryRequest,
  GetMergeCommitRequest,
  GetMergeCommitResponse,
  MergePullRequestByThreeWayResponse,
  MergePullRequestByFastForwardRequest,
  UpdateApprovalRuleTemplateDescriptionResponse,
  PutRepositoryTriggersResponse,
  GetApprovalRuleTemplateRequest,
  ListApprovalRuleTemplatesResponse,
  CreateBranchResponse,
  TagResourceResponse,
  BatchAssociateApprovalRuleTemplateWithRepositoriesResponse,
  GetCommentsForComparedCommitRequest,
  GetMergeOptionsRequest,
  CreatePullRequestApprovalRuleResponse,
  GetMergeConflictsResponse,
  MergeBranchesBySquashResponse,
  UpdatePullRequestTitleRequest,
  CreateApprovalRuleTemplateResponse,
  UpdateApprovalRuleTemplateNameRequest,
  DeleteBranchRequest,
  TagResourceRequest,
  PutFileRequest,
  MergePullRequestBySquashResponse,
  MergeBranchesByFastForwardRequest,
  GetRepositoryTriggersResponse,
  ListAssociatedApprovalRuleTemplatesForRepositoryRequest,
  UpdateDefaultBranchResponse,
  UpdatePullRequestStatusResponse,
  DeleteFileResponse,
  GetRepositoryRequest,
  CreatePullRequestRequest,
  CreateCommitResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.codecommit.{
  CodeCommitAsyncClientBuilder,
  CodeCommitAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import zio.aws.codecommit.model.primitives.BranchName
import scala.jdk.CollectionConverters.*
trait CodeCommit extends AspectSupport[CodeCommit] {
  val api: CodeCommitAsyncClient
  def getCommentReactions(
      request: zio.aws.codecommit.model.GetCommentReactionsRequest
  ): IO[AwsError, zio.aws.codecommit.model.GetCommentReactionsResponse.ReadOnly]
  def updatePullRequestApprovalRuleContent(
      request: zio.aws.codecommit.model.UpdatePullRequestApprovalRuleContentRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.UpdatePullRequestApprovalRuleContentResponse.ReadOnly
  ]
  def describeMergeConflicts(
      request: zio.aws.codecommit.model.DescribeMergeConflictsRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.DescribeMergeConflictsResponse.ReadOnly
  ]
  def updateApprovalRuleTemplateContent(
      request: zio.aws.codecommit.model.UpdateApprovalRuleTemplateContentRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.UpdateApprovalRuleTemplateContentResponse.ReadOnly
  ]
  def updateRepositoryName(
      request: zio.aws.codecommit.model.UpdateRepositoryNameRequest
  ): IO[AwsError, Unit]
  def getRepositoryTriggers(
      request: zio.aws.codecommit.model.GetRepositoryTriggersRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.GetRepositoryTriggersResponse.ReadOnly
  ]
  def updatePullRequestTitle(
      request: zio.aws.codecommit.model.UpdatePullRequestTitleRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.UpdatePullRequestTitleResponse.ReadOnly
  ]
  def postCommentReply(
      request: zio.aws.codecommit.model.PostCommentReplyRequest
  ): IO[AwsError, zio.aws.codecommit.model.PostCommentReplyResponse.ReadOnly]
  def deleteCommentContent(
      request: zio.aws.codecommit.model.DeleteCommentContentRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.DeleteCommentContentResponse.ReadOnly
  ]
  def evaluatePullRequestApprovalRules(
      request: zio.aws.codecommit.model.EvaluatePullRequestApprovalRulesRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.EvaluatePullRequestApprovalRulesResponse.ReadOnly
  ]
  def overridePullRequestApprovalRules(
      request: zio.aws.codecommit.model.OverridePullRequestApprovalRulesRequest
  ): IO[AwsError, Unit]
  def getDifferences(
      request: zio.aws.codecommit.model.GetDifferencesRequest
  ): ZStream[Any, AwsError, zio.aws.codecommit.model.Difference.ReadOnly]
  def getDifferencesPaginated(
      request: zio.aws.codecommit.model.GetDifferencesRequest
  ): IO[AwsError, zio.aws.codecommit.model.GetDifferencesResponse.ReadOnly]
  def updatePullRequestApprovalState(
      request: zio.aws.codecommit.model.UpdatePullRequestApprovalStateRequest
  ): IO[AwsError, Unit]
  def postCommentForPullRequest(
      request: zio.aws.codecommit.model.PostCommentForPullRequestRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.PostCommentForPullRequestResponse.ReadOnly
  ]
  def getFile(
      request: zio.aws.codecommit.model.GetFileRequest
  ): IO[AwsError, ReadOnly]
  def getPullRequestApprovalStates(
      request: zio.aws.codecommit.model.GetPullRequestApprovalStatesRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.GetPullRequestApprovalStatesResponse.ReadOnly
  ]
  def getRepository(
      request: zio.aws.codecommit.model.GetRepositoryRequest
  ): IO[AwsError, zio.aws.codecommit.model.GetRepositoryResponse.ReadOnly]
  def deleteBranch(
      request: zio.aws.codecommit.model.DeleteBranchRequest
  ): IO[AwsError, zio.aws.codecommit.model.DeleteBranchResponse.ReadOnly]
  def deleteRepository(
      request: zio.aws.codecommit.model.DeleteRepositoryRequest
  ): IO[AwsError, zio.aws.codecommit.model.DeleteRepositoryResponse.ReadOnly]
  def getCommit(
      request: zio.aws.codecommit.model.GetCommitRequest
  ): IO[AwsError, zio.aws.codecommit.model.GetCommitResponse.ReadOnly]
  def deleteApprovalRuleTemplate(
      request: zio.aws.codecommit.model.DeleteApprovalRuleTemplateRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.DeleteApprovalRuleTemplateResponse.ReadOnly
  ]
  def updateApprovalRuleTemplateDescription(
      request: zio.aws.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.UpdateApprovalRuleTemplateDescriptionResponse.ReadOnly
  ]
  def getMergeConflicts(
      request: zio.aws.codecommit.model.GetMergeConflictsRequest
  ): IO[AwsError, zio.aws.codecommit.model.GetMergeConflictsResponse.ReadOnly]
  def updatePullRequestDescription(
      request: zio.aws.codecommit.model.UpdatePullRequestDescriptionRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.UpdatePullRequestDescriptionResponse.ReadOnly
  ]
  def testRepositoryTriggers(
      request: zio.aws.codecommit.model.TestRepositoryTriggersRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.TestRepositoryTriggersResponse.ReadOnly
  ]
  def getMergeOptions(
      request: zio.aws.codecommit.model.GetMergeOptionsRequest
  ): IO[AwsError, zio.aws.codecommit.model.GetMergeOptionsResponse.ReadOnly]
  def batchGetRepositories(
      request: zio.aws.codecommit.model.BatchGetRepositoriesRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.BatchGetRepositoriesResponse.ReadOnly
  ]
  def getApprovalRuleTemplate(
      request: zio.aws.codecommit.model.GetApprovalRuleTemplateRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.GetApprovalRuleTemplateResponse.ReadOnly
  ]
  def createPullRequestApprovalRule(
      request: zio.aws.codecommit.model.CreatePullRequestApprovalRuleRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.CreatePullRequestApprovalRuleResponse.ReadOnly
  ]
  def batchDisassociateApprovalRuleTemplateFromRepositories(
      request: zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse.ReadOnly
  ]
  def createBranch(
      request: zio.aws.codecommit.model.CreateBranchRequest
  ): IO[AwsError, Unit]
  def getFolder(
      request: zio.aws.codecommit.model.GetFolderRequest
  ): IO[AwsError, zio.aws.codecommit.model.GetFolderResponse.ReadOnly]
  def createApprovalRuleTemplate(
      request: zio.aws.codecommit.model.CreateApprovalRuleTemplateRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.CreateApprovalRuleTemplateResponse.ReadOnly
  ]
  def createRepository(
      request: zio.aws.codecommit.model.CreateRepositoryRequest
  ): IO[AwsError, zio.aws.codecommit.model.CreateRepositoryResponse.ReadOnly]
  def updateComment(
      request: zio.aws.codecommit.model.UpdateCommentRequest
  ): IO[AwsError, zio.aws.codecommit.model.UpdateCommentResponse.ReadOnly]
  def postCommentForComparedCommit(
      request: zio.aws.codecommit.model.PostCommentForComparedCommitRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.PostCommentForComparedCommitResponse.ReadOnly
  ]
  def createUnreferencedMergeCommit(
      request: zio.aws.codecommit.model.CreateUnreferencedMergeCommitRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.CreateUnreferencedMergeCommitResponse.ReadOnly
  ]
  def mergeBranchesByThreeWay(
      request: zio.aws.codecommit.model.MergeBranchesByThreeWayRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.MergeBranchesByThreeWayResponse.ReadOnly
  ]
  def listApprovalRuleTemplates(
      request: zio.aws.codecommit.model.ListApprovalRuleTemplatesRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.ListApprovalRuleTemplatesResponse.ReadOnly
  ]
  def putRepositoryTriggers(
      request: zio.aws.codecommit.model.PutRepositoryTriggersRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.PutRepositoryTriggersResponse.ReadOnly
  ]
  def putFile(
      request: zio.aws.codecommit.model.PutFileRequest
  ): IO[AwsError, zio.aws.codecommit.model.PutFileResponse.ReadOnly]
  def describePullRequestEvents(
      request: zio.aws.codecommit.model.DescribePullRequestEventsRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.DescribePullRequestEventsResponse.ReadOnly
  ]
  def disassociateApprovalRuleTemplateFromRepository(
      request: zio.aws.codecommit.model.DisassociateApprovalRuleTemplateFromRepositoryRequest
  ): IO[AwsError, Unit]
  def putCommentReaction(
      request: zio.aws.codecommit.model.PutCommentReactionRequest
  ): IO[AwsError, Unit]
  def listRepositoriesForApprovalRuleTemplate(
      request: zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse.ReadOnly
  ]
  def getCommentsForComparedCommit(
      request: zio.aws.codecommit.model.GetCommentsForComparedCommitRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.GetCommentsForComparedCommitResponse.ReadOnly
  ]
  def mergePullRequestByFastForward(
      request: zio.aws.codecommit.model.MergePullRequestByFastForwardRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.MergePullRequestByFastForwardResponse.ReadOnly
  ]
  def listAssociatedApprovalRuleTemplatesForRepository(
      request: zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse.ReadOnly
  ]
  def updateApprovalRuleTemplateName(
      request: zio.aws.codecommit.model.UpdateApprovalRuleTemplateNameRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.UpdateApprovalRuleTemplateNameResponse.ReadOnly
  ]
  def listBranches(
      request: zio.aws.codecommit.model.ListBranchesRequest
  ): ZStream[Any, AwsError, BranchName]
  def listBranchesPaginated(
      request: zio.aws.codecommit.model.ListBranchesRequest
  ): IO[AwsError, zio.aws.codecommit.model.ListBranchesResponse.ReadOnly]
  def untagResource(
      request: zio.aws.codecommit.model.UntagResourceRequest
  ): IO[AwsError, Unit]
  def getPullRequestOverrideState(
      request: zio.aws.codecommit.model.GetPullRequestOverrideStateRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.GetPullRequestOverrideStateResponse.ReadOnly
  ]
  def mergeBranchesBySquash(
      request: zio.aws.codecommit.model.MergeBranchesBySquashRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.MergeBranchesBySquashResponse.ReadOnly
  ]
  def mergePullRequestByThreeWay(
      request: zio.aws.codecommit.model.MergePullRequestByThreeWayRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.MergePullRequestByThreeWayResponse.ReadOnly
  ]
  def batchAssociateApprovalRuleTemplateWithRepositories(
      request: zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse.ReadOnly
  ]
  def deleteFile(
      request: zio.aws.codecommit.model.DeleteFileRequest
  ): IO[AwsError, zio.aws.codecommit.model.DeleteFileResponse.ReadOnly]
  def updatePullRequestStatus(
      request: zio.aws.codecommit.model.UpdatePullRequestStatusRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.UpdatePullRequestStatusResponse.ReadOnly
  ]
  def deletePullRequestApprovalRule(
      request: zio.aws.codecommit.model.DeletePullRequestApprovalRuleRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.DeletePullRequestApprovalRuleResponse.ReadOnly
  ]
  def listRepositories(
      request: zio.aws.codecommit.model.ListRepositoriesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.codecommit.model.RepositoryNameIdPair.ReadOnly
  ]
  def listRepositoriesPaginated(
      request: zio.aws.codecommit.model.ListRepositoriesRequest
  ): IO[AwsError, zio.aws.codecommit.model.ListRepositoriesResponse.ReadOnly]
  def getBranch(
      request: zio.aws.codecommit.model.GetBranchRequest
  ): IO[AwsError, zio.aws.codecommit.model.GetBranchResponse.ReadOnly]
  def getCommentsForPullRequest(
      request: zio.aws.codecommit.model.GetCommentsForPullRequestRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.GetCommentsForPullRequestResponse.ReadOnly
  ]
  def batchGetCommits(
      request: zio.aws.codecommit.model.BatchGetCommitsRequest
  ): IO[AwsError, zio.aws.codecommit.model.BatchGetCommitsResponse.ReadOnly]
  def mergeBranchesByFastForward(
      request: zio.aws.codecommit.model.MergeBranchesByFastForwardRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.MergeBranchesByFastForwardResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.codecommit.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.codecommit.model.ListTagsForResourceResponse.ReadOnly]
  def associateApprovalRuleTemplateWithRepository(
      request: zio.aws.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryRequest
  ): IO[AwsError, Unit]
  def tagResource(
      request: zio.aws.codecommit.model.TagResourceRequest
  ): IO[AwsError, Unit]
  def createCommit(
      request: zio.aws.codecommit.model.CreateCommitRequest
  ): IO[AwsError, zio.aws.codecommit.model.CreateCommitResponse.ReadOnly]
  def updateDefaultBranch(
      request: zio.aws.codecommit.model.UpdateDefaultBranchRequest
  ): IO[AwsError, Unit]
  def getBlob(
      request: zio.aws.codecommit.model.GetBlobRequest
  ): IO[AwsError, zio.aws.codecommit.model.GetBlobResponse.ReadOnly]
  def getPullRequest(
      request: zio.aws.codecommit.model.GetPullRequestRequest
  ): IO[AwsError, zio.aws.codecommit.model.GetPullRequestResponse.ReadOnly]
  def getComment(
      request: zio.aws.codecommit.model.GetCommentRequest
  ): IO[AwsError, zio.aws.codecommit.model.GetCommentResponse.ReadOnly]
  def listPullRequests(
      request: zio.aws.codecommit.model.ListPullRequestsRequest
  ): IO[AwsError, zio.aws.codecommit.model.ListPullRequestsResponse.ReadOnly]
  def batchDescribeMergeConflicts(
      request: zio.aws.codecommit.model.BatchDescribeMergeConflictsRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.BatchDescribeMergeConflictsResponse.ReadOnly
  ]
  def createPullRequest(
      request: zio.aws.codecommit.model.CreatePullRequestRequest
  ): IO[AwsError, zio.aws.codecommit.model.CreatePullRequestResponse.ReadOnly]
  def mergePullRequestBySquash(
      request: zio.aws.codecommit.model.MergePullRequestBySquashRequest
  ): IO[
    AwsError,
    zio.aws.codecommit.model.MergePullRequestBySquashResponse.ReadOnly
  ]
  def getMergeCommit(
      request: zio.aws.codecommit.model.GetMergeCommitRequest
  ): IO[AwsError, zio.aws.codecommit.model.GetMergeCommitResponse.ReadOnly]
  def updateRepositoryDescription(
      request: zio.aws.codecommit.model.UpdateRepositoryDescriptionRequest
  ): IO[AwsError, Unit]
}
object CodeCommit {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CodeCommit] = customized(
    identity
  )
  def customized(
      customization: CodeCommitAsyncClientBuilder => CodeCommitAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CodeCommit] = managed(
    customization
  ).toLayer
  def managed(
      customization: CodeCommitAsyncClientBuilder => CodeCommitAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, CodeCommit] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = CodeCommitAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[CodeCommitAsyncClient, CodeCommitAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[CodeCommitAsyncClient, CodeCommitAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new CodeCommitImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class CodeCommitImpl[R](
      override val api: CodeCommitAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CodeCommit
      with AwsServiceBase[R] {
    override val serviceName: String = "CodeCommit"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CodeCommitImpl[R1] = new CodeCommitImpl(api, newAspect, r)
    def getCommentReactions(
        request: zio.aws.codecommit.model.GetCommentReactionsRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.GetCommentReactionsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCommentReactionsRequest,
      GetCommentReactionsResponse
    ]("getCommentReactions", api.getCommentReactions)(request.buildAwsValue())
      .map(zio.aws.codecommit.model.GetCommentReactionsResponse.wrap)
      .provideEnvironment(r)
    def updatePullRequestApprovalRuleContent(
        request: zio.aws.codecommit.model.UpdatePullRequestApprovalRuleContentRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.UpdatePullRequestApprovalRuleContentResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdatePullRequestApprovalRuleContentRequest,
      UpdatePullRequestApprovalRuleContentResponse
    ](
      "updatePullRequestApprovalRuleContent",
      api.updatePullRequestApprovalRuleContent
    )(request.buildAwsValue())
      .map(
        zio.aws.codecommit.model.UpdatePullRequestApprovalRuleContentResponse.wrap
      )
      .provideEnvironment(r)
    def describeMergeConflicts(
        request: zio.aws.codecommit.model.DescribeMergeConflictsRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.DescribeMergeConflictsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMergeConflictsRequest,
      DescribeMergeConflictsResponse
    ]("describeMergeConflicts", api.describeMergeConflicts)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.DescribeMergeConflictsResponse.wrap)
      .provideEnvironment(r)
    def updateApprovalRuleTemplateContent(
        request: zio.aws.codecommit.model.UpdateApprovalRuleTemplateContentRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.UpdateApprovalRuleTemplateContentResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateApprovalRuleTemplateContentRequest,
      UpdateApprovalRuleTemplateContentResponse
    ](
      "updateApprovalRuleTemplateContent",
      api.updateApprovalRuleTemplateContent
    )(request.buildAwsValue())
      .map(
        zio.aws.codecommit.model.UpdateApprovalRuleTemplateContentResponse.wrap
      )
      .provideEnvironment(r)
    def updateRepositoryName(
        request: zio.aws.codecommit.model.UpdateRepositoryNameRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdateRepositoryNameRequest,
      UpdateRepositoryNameResponse
    ]("updateRepositoryName", api.updateRepositoryName)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getRepositoryTriggers(
        request: zio.aws.codecommit.model.GetRepositoryTriggersRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.GetRepositoryTriggersResponse.ReadOnly
    ] = asyncRequestResponse[
      GetRepositoryTriggersRequest,
      GetRepositoryTriggersResponse
    ]("getRepositoryTriggers", api.getRepositoryTriggers)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.GetRepositoryTriggersResponse.wrap)
      .provideEnvironment(r)
    def updatePullRequestTitle(
        request: zio.aws.codecommit.model.UpdatePullRequestTitleRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.UpdatePullRequestTitleResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdatePullRequestTitleRequest,
      UpdatePullRequestTitleResponse
    ]("updatePullRequestTitle", api.updatePullRequestTitle)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.UpdatePullRequestTitleResponse.wrap)
      .provideEnvironment(r)
    def postCommentReply(
        request: zio.aws.codecommit.model.PostCommentReplyRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.PostCommentReplyResponse.ReadOnly
    ] = asyncRequestResponse[PostCommentReplyRequest, PostCommentReplyResponse](
      "postCommentReply",
      api.postCommentReply
    )(request.buildAwsValue())
      .map(zio.aws.codecommit.model.PostCommentReplyResponse.wrap)
      .provideEnvironment(r)
    def deleteCommentContent(
        request: zio.aws.codecommit.model.DeleteCommentContentRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.DeleteCommentContentResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteCommentContentRequest,
      DeleteCommentContentResponse
    ]("deleteCommentContent", api.deleteCommentContent)(request.buildAwsValue())
      .map(zio.aws.codecommit.model.DeleteCommentContentResponse.wrap)
      .provideEnvironment(r)
    def evaluatePullRequestApprovalRules(
        request: zio.aws.codecommit.model.EvaluatePullRequestApprovalRulesRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.EvaluatePullRequestApprovalRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      EvaluatePullRequestApprovalRulesRequest,
      EvaluatePullRequestApprovalRulesResponse
    ]("evaluatePullRequestApprovalRules", api.evaluatePullRequestApprovalRules)(
      request.buildAwsValue()
    ).map(
      zio.aws.codecommit.model.EvaluatePullRequestApprovalRulesResponse.wrap
    ).provideEnvironment(r)
    def overridePullRequestApprovalRules(
        request: zio.aws.codecommit.model.OverridePullRequestApprovalRulesRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      OverridePullRequestApprovalRulesRequest,
      OverridePullRequestApprovalRulesResponse
    ]("overridePullRequestApprovalRules", api.overridePullRequestApprovalRules)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getDifferences(
        request: zio.aws.codecommit.model.GetDifferencesRequest
    ): ZStream[Any, AwsError, zio.aws.codecommit.model.Difference.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetDifferencesRequest,
        GetDifferencesResponse,
        Difference
      ](
        "getDifferences",
        api.getDifferences,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.differences().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.codecommit.model.Difference.wrap(item))
        .provideEnvironment(r)
    def getDifferencesPaginated(
        request: zio.aws.codecommit.model.GetDifferencesRequest
    ): IO[AwsError, zio.aws.codecommit.model.GetDifferencesResponse.ReadOnly] =
      asyncRequestResponse[GetDifferencesRequest, GetDifferencesResponse](
        "getDifferences",
        api.getDifferences
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.GetDifferencesResponse.wrap)
        .provideEnvironment(r)
    def updatePullRequestApprovalState(
        request: zio.aws.codecommit.model.UpdatePullRequestApprovalStateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdatePullRequestApprovalStateRequest,
      UpdatePullRequestApprovalStateResponse
    ]("updatePullRequestApprovalState", api.updatePullRequestApprovalState)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def postCommentForPullRequest(
        request: zio.aws.codecommit.model.PostCommentForPullRequestRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.PostCommentForPullRequestResponse.ReadOnly
    ] = asyncRequestResponse[
      PostCommentForPullRequestRequest,
      PostCommentForPullRequestResponse
    ]("postCommentForPullRequest", api.postCommentForPullRequest)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.PostCommentForPullRequestResponse.wrap)
      .provideEnvironment(r)
    def getFile(
        request: zio.aws.codecommit.model.GetFileRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[GetFileRequest, GetFileResponse](
        "getFile",
        api.getFile
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.GetFileResponse.wrap)
        .provideEnvironment(r)
    def getPullRequestApprovalStates(
        request: zio.aws.codecommit.model.GetPullRequestApprovalStatesRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.GetPullRequestApprovalStatesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetPullRequestApprovalStatesRequest,
      GetPullRequestApprovalStatesResponse
    ]("getPullRequestApprovalStates", api.getPullRequestApprovalStates)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.GetPullRequestApprovalStatesResponse.wrap)
      .provideEnvironment(r)
    def getRepository(
        request: zio.aws.codecommit.model.GetRepositoryRequest
    ): IO[AwsError, zio.aws.codecommit.model.GetRepositoryResponse.ReadOnly] =
      asyncRequestResponse[GetRepositoryRequest, GetRepositoryResponse](
        "getRepository",
        api.getRepository
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.GetRepositoryResponse.wrap)
        .provideEnvironment(r)
    def deleteBranch(
        request: zio.aws.codecommit.model.DeleteBranchRequest
    ): IO[AwsError, zio.aws.codecommit.model.DeleteBranchResponse.ReadOnly] =
      asyncRequestResponse[DeleteBranchRequest, DeleteBranchResponse](
        "deleteBranch",
        api.deleteBranch
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.DeleteBranchResponse.wrap)
        .provideEnvironment(r)
    def deleteRepository(
        request: zio.aws.codecommit.model.DeleteRepositoryRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.DeleteRepositoryResponse.ReadOnly
    ] = asyncRequestResponse[DeleteRepositoryRequest, DeleteRepositoryResponse](
      "deleteRepository",
      api.deleteRepository
    )(request.buildAwsValue())
      .map(zio.aws.codecommit.model.DeleteRepositoryResponse.wrap)
      .provideEnvironment(r)
    def getCommit(
        request: zio.aws.codecommit.model.GetCommitRequest
    ): IO[AwsError, zio.aws.codecommit.model.GetCommitResponse.ReadOnly] =
      asyncRequestResponse[GetCommitRequest, GetCommitResponse](
        "getCommit",
        api.getCommit
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.GetCommitResponse.wrap)
        .provideEnvironment(r)
    def deleteApprovalRuleTemplate(
        request: zio.aws.codecommit.model.DeleteApprovalRuleTemplateRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.DeleteApprovalRuleTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteApprovalRuleTemplateRequest,
      DeleteApprovalRuleTemplateResponse
    ]("deleteApprovalRuleTemplate", api.deleteApprovalRuleTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.DeleteApprovalRuleTemplateResponse.wrap)
      .provideEnvironment(r)
    def updateApprovalRuleTemplateDescription(
        request: zio.aws.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.UpdateApprovalRuleTemplateDescriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateApprovalRuleTemplateDescriptionRequest,
      UpdateApprovalRuleTemplateDescriptionResponse
    ](
      "updateApprovalRuleTemplateDescription",
      api.updateApprovalRuleTemplateDescription
    )(request.buildAwsValue())
      .map(
        zio.aws.codecommit.model.UpdateApprovalRuleTemplateDescriptionResponse.wrap
      )
      .provideEnvironment(r)
    def getMergeConflicts(
        request: zio.aws.codecommit.model.GetMergeConflictsRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.GetMergeConflictsResponse.ReadOnly
    ] =
      asyncRequestResponse[GetMergeConflictsRequest, GetMergeConflictsResponse](
        "getMergeConflicts",
        api.getMergeConflicts
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.GetMergeConflictsResponse.wrap)
        .provideEnvironment(r)
    def updatePullRequestDescription(
        request: zio.aws.codecommit.model.UpdatePullRequestDescriptionRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.UpdatePullRequestDescriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdatePullRequestDescriptionRequest,
      UpdatePullRequestDescriptionResponse
    ]("updatePullRequestDescription", api.updatePullRequestDescription)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.UpdatePullRequestDescriptionResponse.wrap)
      .provideEnvironment(r)
    def testRepositoryTriggers(
        request: zio.aws.codecommit.model.TestRepositoryTriggersRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.TestRepositoryTriggersResponse.ReadOnly
    ] = asyncRequestResponse[
      TestRepositoryTriggersRequest,
      TestRepositoryTriggersResponse
    ]("testRepositoryTriggers", api.testRepositoryTriggers)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.TestRepositoryTriggersResponse.wrap)
      .provideEnvironment(r)
    def getMergeOptions(
        request: zio.aws.codecommit.model.GetMergeOptionsRequest
    ): IO[AwsError, zio.aws.codecommit.model.GetMergeOptionsResponse.ReadOnly] =
      asyncRequestResponse[GetMergeOptionsRequest, GetMergeOptionsResponse](
        "getMergeOptions",
        api.getMergeOptions
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.GetMergeOptionsResponse.wrap)
        .provideEnvironment(r)
    def batchGetRepositories(
        request: zio.aws.codecommit.model.BatchGetRepositoriesRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.BatchGetRepositoriesResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchGetRepositoriesRequest,
      BatchGetRepositoriesResponse
    ]("batchGetRepositories", api.batchGetRepositories)(request.buildAwsValue())
      .map(zio.aws.codecommit.model.BatchGetRepositoriesResponse.wrap)
      .provideEnvironment(r)
    def getApprovalRuleTemplate(
        request: zio.aws.codecommit.model.GetApprovalRuleTemplateRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.GetApprovalRuleTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      GetApprovalRuleTemplateRequest,
      GetApprovalRuleTemplateResponse
    ]("getApprovalRuleTemplate", api.getApprovalRuleTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.GetApprovalRuleTemplateResponse.wrap)
      .provideEnvironment(r)
    def createPullRequestApprovalRule(
        request: zio.aws.codecommit.model.CreatePullRequestApprovalRuleRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.CreatePullRequestApprovalRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      CreatePullRequestApprovalRuleRequest,
      CreatePullRequestApprovalRuleResponse
    ]("createPullRequestApprovalRule", api.createPullRequestApprovalRule)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.CreatePullRequestApprovalRuleResponse.wrap)
      .provideEnvironment(r)
    def batchDisassociateApprovalRuleTemplateFromRepositories(
        request: zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest,
      BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse
    ](
      "batchDisassociateApprovalRuleTemplateFromRepositories",
      api.batchDisassociateApprovalRuleTemplateFromRepositories
    )(request.buildAwsValue())
      .map(
        zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse.wrap
      )
      .provideEnvironment(r)
    def createBranch(
        request: zio.aws.codecommit.model.CreateBranchRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[CreateBranchRequest, CreateBranchResponse](
        "createBranch",
        api.createBranch
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getFolder(
        request: zio.aws.codecommit.model.GetFolderRequest
    ): IO[AwsError, zio.aws.codecommit.model.GetFolderResponse.ReadOnly] =
      asyncRequestResponse[GetFolderRequest, GetFolderResponse](
        "getFolder",
        api.getFolder
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.GetFolderResponse.wrap)
        .provideEnvironment(r)
    def createApprovalRuleTemplate(
        request: zio.aws.codecommit.model.CreateApprovalRuleTemplateRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.CreateApprovalRuleTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateApprovalRuleTemplateRequest,
      CreateApprovalRuleTemplateResponse
    ]("createApprovalRuleTemplate", api.createApprovalRuleTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.CreateApprovalRuleTemplateResponse.wrap)
      .provideEnvironment(r)
    def createRepository(
        request: zio.aws.codecommit.model.CreateRepositoryRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.CreateRepositoryResponse.ReadOnly
    ] = asyncRequestResponse[CreateRepositoryRequest, CreateRepositoryResponse](
      "createRepository",
      api.createRepository
    )(request.buildAwsValue())
      .map(zio.aws.codecommit.model.CreateRepositoryResponse.wrap)
      .provideEnvironment(r)
    def updateComment(
        request: zio.aws.codecommit.model.UpdateCommentRequest
    ): IO[AwsError, zio.aws.codecommit.model.UpdateCommentResponse.ReadOnly] =
      asyncRequestResponse[UpdateCommentRequest, UpdateCommentResponse](
        "updateComment",
        api.updateComment
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.UpdateCommentResponse.wrap)
        .provideEnvironment(r)
    def postCommentForComparedCommit(
        request: zio.aws.codecommit.model.PostCommentForComparedCommitRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.PostCommentForComparedCommitResponse.ReadOnly
    ] = asyncRequestResponse[
      PostCommentForComparedCommitRequest,
      PostCommentForComparedCommitResponse
    ]("postCommentForComparedCommit", api.postCommentForComparedCommit)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.PostCommentForComparedCommitResponse.wrap)
      .provideEnvironment(r)
    def createUnreferencedMergeCommit(
        request: zio.aws.codecommit.model.CreateUnreferencedMergeCommitRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.CreateUnreferencedMergeCommitResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateUnreferencedMergeCommitRequest,
      CreateUnreferencedMergeCommitResponse
    ]("createUnreferencedMergeCommit", api.createUnreferencedMergeCommit)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.CreateUnreferencedMergeCommitResponse.wrap)
      .provideEnvironment(r)
    def mergeBranchesByThreeWay(
        request: zio.aws.codecommit.model.MergeBranchesByThreeWayRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.MergeBranchesByThreeWayResponse.ReadOnly
    ] = asyncRequestResponse[
      MergeBranchesByThreeWayRequest,
      MergeBranchesByThreeWayResponse
    ]("mergeBranchesByThreeWay", api.mergeBranchesByThreeWay)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.MergeBranchesByThreeWayResponse.wrap)
      .provideEnvironment(r)
    def listApprovalRuleTemplates(
        request: zio.aws.codecommit.model.ListApprovalRuleTemplatesRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.ListApprovalRuleTemplatesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListApprovalRuleTemplatesRequest,
      ListApprovalRuleTemplatesResponse
    ]("listApprovalRuleTemplates", api.listApprovalRuleTemplates)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.ListApprovalRuleTemplatesResponse.wrap)
      .provideEnvironment(r)
    def putRepositoryTriggers(
        request: zio.aws.codecommit.model.PutRepositoryTriggersRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.PutRepositoryTriggersResponse.ReadOnly
    ] = asyncRequestResponse[
      PutRepositoryTriggersRequest,
      PutRepositoryTriggersResponse
    ]("putRepositoryTriggers", api.putRepositoryTriggers)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.PutRepositoryTriggersResponse.wrap)
      .provideEnvironment(r)
    def putFile(
        request: zio.aws.codecommit.model.PutFileRequest
    ): IO[AwsError, zio.aws.codecommit.model.PutFileResponse.ReadOnly] =
      asyncRequestResponse[PutFileRequest, PutFileResponse](
        "putFile",
        api.putFile
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.PutFileResponse.wrap)
        .provideEnvironment(r)
    def describePullRequestEvents(
        request: zio.aws.codecommit.model.DescribePullRequestEventsRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.DescribePullRequestEventsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribePullRequestEventsRequest,
      DescribePullRequestEventsResponse
    ]("describePullRequestEvents", api.describePullRequestEvents)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.DescribePullRequestEventsResponse.wrap)
      .provideEnvironment(r)
    def disassociateApprovalRuleTemplateFromRepository(
        request: zio.aws.codecommit.model.DisassociateApprovalRuleTemplateFromRepositoryRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DisassociateApprovalRuleTemplateFromRepositoryRequest,
      DisassociateApprovalRuleTemplateFromRepositoryResponse
    ](
      "disassociateApprovalRuleTemplateFromRepository",
      api.disassociateApprovalRuleTemplateFromRepository
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def putCommentReaction(
        request: zio.aws.codecommit.model.PutCommentReactionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutCommentReactionRequest,
      PutCommentReactionResponse
    ]("putCommentReaction", api.putCommentReaction)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listRepositoriesForApprovalRuleTemplate(
        request: zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      ListRepositoriesForApprovalRuleTemplateRequest,
      ListRepositoriesForApprovalRuleTemplateResponse
    ](
      "listRepositoriesForApprovalRuleTemplate",
      api.listRepositoriesForApprovalRuleTemplate
    )(request.buildAwsValue())
      .map(
        zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse.wrap
      )
      .provideEnvironment(r)
    def getCommentsForComparedCommit(
        request: zio.aws.codecommit.model.GetCommentsForComparedCommitRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.GetCommentsForComparedCommitResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCommentsForComparedCommitRequest,
      GetCommentsForComparedCommitResponse
    ]("getCommentsForComparedCommit", api.getCommentsForComparedCommit)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.GetCommentsForComparedCommitResponse.wrap)
      .provideEnvironment(r)
    def mergePullRequestByFastForward(
        request: zio.aws.codecommit.model.MergePullRequestByFastForwardRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.MergePullRequestByFastForwardResponse.ReadOnly
    ] = asyncRequestResponse[
      MergePullRequestByFastForwardRequest,
      MergePullRequestByFastForwardResponse
    ]("mergePullRequestByFastForward", api.mergePullRequestByFastForward)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.MergePullRequestByFastForwardResponse.wrap)
      .provideEnvironment(r)
    def listAssociatedApprovalRuleTemplatesForRepository(
        request: zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAssociatedApprovalRuleTemplatesForRepositoryRequest,
      ListAssociatedApprovalRuleTemplatesForRepositoryResponse
    ](
      "listAssociatedApprovalRuleTemplatesForRepository",
      api.listAssociatedApprovalRuleTemplatesForRepository
    )(request.buildAwsValue())
      .map(
        zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse.wrap
      )
      .provideEnvironment(r)
    def updateApprovalRuleTemplateName(
        request: zio.aws.codecommit.model.UpdateApprovalRuleTemplateNameRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.UpdateApprovalRuleTemplateNameResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateApprovalRuleTemplateNameRequest,
      UpdateApprovalRuleTemplateNameResponse
    ]("updateApprovalRuleTemplateName", api.updateApprovalRuleTemplateName)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.UpdateApprovalRuleTemplateNameResponse.wrap)
      .provideEnvironment(r)
    def listBranches(
        request: zio.aws.codecommit.model.ListBranchesRequest
    ): ZStream[Any, AwsError, BranchName] = asyncJavaPaginatedRequest[
      ListBranchesRequest,
      java.lang.String,
      ListBranchesPublisher
    ]("listBranches", api.listBranchesPaginator, _.branches())(
      request.buildAwsValue()
    ).map(item => zio.aws.codecommit.model.primitives.BranchName(item))
      .provideEnvironment(r)
    def listBranchesPaginated(
        request: zio.aws.codecommit.model.ListBranchesRequest
    ): IO[AwsError, zio.aws.codecommit.model.ListBranchesResponse.ReadOnly] =
      asyncRequestResponse[ListBranchesRequest, ListBranchesResponse](
        "listBranches",
        api.listBranches
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.ListBranchesResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.codecommit.model.UntagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getPullRequestOverrideState(
        request: zio.aws.codecommit.model.GetPullRequestOverrideStateRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.GetPullRequestOverrideStateResponse.ReadOnly
    ] = asyncRequestResponse[
      GetPullRequestOverrideStateRequest,
      GetPullRequestOverrideStateResponse
    ]("getPullRequestOverrideState", api.getPullRequestOverrideState)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.GetPullRequestOverrideStateResponse.wrap)
      .provideEnvironment(r)
    def mergeBranchesBySquash(
        request: zio.aws.codecommit.model.MergeBranchesBySquashRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.MergeBranchesBySquashResponse.ReadOnly
    ] = asyncRequestResponse[
      MergeBranchesBySquashRequest,
      MergeBranchesBySquashResponse
    ]("mergeBranchesBySquash", api.mergeBranchesBySquash)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.MergeBranchesBySquashResponse.wrap)
      .provideEnvironment(r)
    def mergePullRequestByThreeWay(
        request: zio.aws.codecommit.model.MergePullRequestByThreeWayRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.MergePullRequestByThreeWayResponse.ReadOnly
    ] = asyncRequestResponse[
      MergePullRequestByThreeWayRequest,
      MergePullRequestByThreeWayResponse
    ]("mergePullRequestByThreeWay", api.mergePullRequestByThreeWay)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.MergePullRequestByThreeWayResponse.wrap)
      .provideEnvironment(r)
    def batchAssociateApprovalRuleTemplateWithRepositories(
        request: zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchAssociateApprovalRuleTemplateWithRepositoriesRequest,
      BatchAssociateApprovalRuleTemplateWithRepositoriesResponse
    ](
      "batchAssociateApprovalRuleTemplateWithRepositories",
      api.batchAssociateApprovalRuleTemplateWithRepositories
    )(request.buildAwsValue())
      .map(
        zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse.wrap
      )
      .provideEnvironment(r)
    def deleteFile(
        request: zio.aws.codecommit.model.DeleteFileRequest
    ): IO[AwsError, zio.aws.codecommit.model.DeleteFileResponse.ReadOnly] =
      asyncRequestResponse[DeleteFileRequest, DeleteFileResponse](
        "deleteFile",
        api.deleteFile
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.DeleteFileResponse.wrap)
        .provideEnvironment(r)
    def updatePullRequestStatus(
        request: zio.aws.codecommit.model.UpdatePullRequestStatusRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.UpdatePullRequestStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdatePullRequestStatusRequest,
      UpdatePullRequestStatusResponse
    ]("updatePullRequestStatus", api.updatePullRequestStatus)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.UpdatePullRequestStatusResponse.wrap)
      .provideEnvironment(r)
    def deletePullRequestApprovalRule(
        request: zio.aws.codecommit.model.DeletePullRequestApprovalRuleRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.DeletePullRequestApprovalRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      DeletePullRequestApprovalRuleRequest,
      DeletePullRequestApprovalRuleResponse
    ]("deletePullRequestApprovalRule", api.deletePullRequestApprovalRule)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.DeletePullRequestApprovalRuleResponse.wrap)
      .provideEnvironment(r)
    def listRepositories(
        request: zio.aws.codecommit.model.ListRepositoriesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.codecommit.model.RepositoryNameIdPair.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListRepositoriesRequest,
      RepositoryNameIdPair,
      ListRepositoriesPublisher
    ]("listRepositories", api.listRepositoriesPaginator, _.repositories())(
      request.buildAwsValue()
    ).map(item => zio.aws.codecommit.model.RepositoryNameIdPair.wrap(item))
      .provideEnvironment(r)
    def listRepositoriesPaginated(
        request: zio.aws.codecommit.model.ListRepositoriesRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.ListRepositoriesResponse.ReadOnly
    ] = asyncRequestResponse[ListRepositoriesRequest, ListRepositoriesResponse](
      "listRepositories",
      api.listRepositories
    )(request.buildAwsValue())
      .map(zio.aws.codecommit.model.ListRepositoriesResponse.wrap)
      .provideEnvironment(r)
    def getBranch(
        request: zio.aws.codecommit.model.GetBranchRequest
    ): IO[AwsError, zio.aws.codecommit.model.GetBranchResponse.ReadOnly] =
      asyncRequestResponse[GetBranchRequest, GetBranchResponse](
        "getBranch",
        api.getBranch
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.GetBranchResponse.wrap)
        .provideEnvironment(r)
    def getCommentsForPullRequest(
        request: zio.aws.codecommit.model.GetCommentsForPullRequestRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.GetCommentsForPullRequestResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCommentsForPullRequestRequest,
      GetCommentsForPullRequestResponse
    ]("getCommentsForPullRequest", api.getCommentsForPullRequest)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.GetCommentsForPullRequestResponse.wrap)
      .provideEnvironment(r)
    def batchGetCommits(
        request: zio.aws.codecommit.model.BatchGetCommitsRequest
    ): IO[AwsError, zio.aws.codecommit.model.BatchGetCommitsResponse.ReadOnly] =
      asyncRequestResponse[BatchGetCommitsRequest, BatchGetCommitsResponse](
        "batchGetCommits",
        api.batchGetCommits
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.BatchGetCommitsResponse.wrap)
        .provideEnvironment(r)
    def mergeBranchesByFastForward(
        request: zio.aws.codecommit.model.MergeBranchesByFastForwardRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.MergeBranchesByFastForwardResponse.ReadOnly
    ] = asyncRequestResponse[
      MergeBranchesByFastForwardRequest,
      MergeBranchesByFastForwardResponse
    ]("mergeBranchesByFastForward", api.mergeBranchesByFastForward)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.MergeBranchesByFastForwardResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.codecommit.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.codecommit.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def associateApprovalRuleTemplateWithRepository(
        request: zio.aws.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      AssociateApprovalRuleTemplateWithRepositoryRequest,
      AssociateApprovalRuleTemplateWithRepositoryResponse
    ](
      "associateApprovalRuleTemplateWithRepository",
      api.associateApprovalRuleTemplateWithRepository
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def tagResource(
        request: zio.aws.codecommit.model.TagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createCommit(
        request: zio.aws.codecommit.model.CreateCommitRequest
    ): IO[AwsError, zio.aws.codecommit.model.CreateCommitResponse.ReadOnly] =
      asyncRequestResponse[CreateCommitRequest, CreateCommitResponse](
        "createCommit",
        api.createCommit
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.CreateCommitResponse.wrap)
        .provideEnvironment(r)
    def updateDefaultBranch(
        request: zio.aws.codecommit.model.UpdateDefaultBranchRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdateDefaultBranchRequest,
      UpdateDefaultBranchResponse
    ]("updateDefaultBranch", api.updateDefaultBranch)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getBlob(
        request: zio.aws.codecommit.model.GetBlobRequest
    ): IO[AwsError, zio.aws.codecommit.model.GetBlobResponse.ReadOnly] =
      asyncRequestResponse[GetBlobRequest, GetBlobResponse](
        "getBlob",
        api.getBlob
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.GetBlobResponse.wrap)
        .provideEnvironment(r)
    def getPullRequest(
        request: zio.aws.codecommit.model.GetPullRequestRequest
    ): IO[AwsError, zio.aws.codecommit.model.GetPullRequestResponse.ReadOnly] =
      asyncRequestResponse[GetPullRequestRequest, GetPullRequestResponse](
        "getPullRequest",
        api.getPullRequest
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.GetPullRequestResponse.wrap)
        .provideEnvironment(r)
    def getComment(
        request: zio.aws.codecommit.model.GetCommentRequest
    ): IO[AwsError, zio.aws.codecommit.model.GetCommentResponse.ReadOnly] =
      asyncRequestResponse[GetCommentRequest, GetCommentResponse](
        "getComment",
        api.getComment
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.GetCommentResponse.wrap)
        .provideEnvironment(r)
    def listPullRequests(
        request: zio.aws.codecommit.model.ListPullRequestsRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.ListPullRequestsResponse.ReadOnly
    ] = asyncRequestResponse[ListPullRequestsRequest, ListPullRequestsResponse](
      "listPullRequests",
      api.listPullRequests
    )(request.buildAwsValue())
      .map(zio.aws.codecommit.model.ListPullRequestsResponse.wrap)
      .provideEnvironment(r)
    def batchDescribeMergeConflicts(
        request: zio.aws.codecommit.model.BatchDescribeMergeConflictsRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.BatchDescribeMergeConflictsResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchDescribeMergeConflictsRequest,
      BatchDescribeMergeConflictsResponse
    ]("batchDescribeMergeConflicts", api.batchDescribeMergeConflicts)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.BatchDescribeMergeConflictsResponse.wrap)
      .provideEnvironment(r)
    def createPullRequest(
        request: zio.aws.codecommit.model.CreatePullRequestRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.CreatePullRequestResponse.ReadOnly
    ] =
      asyncRequestResponse[CreatePullRequestRequest, CreatePullRequestResponse](
        "createPullRequest",
        api.createPullRequest
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.CreatePullRequestResponse.wrap)
        .provideEnvironment(r)
    def mergePullRequestBySquash(
        request: zio.aws.codecommit.model.MergePullRequestBySquashRequest
    ): IO[
      AwsError,
      zio.aws.codecommit.model.MergePullRequestBySquashResponse.ReadOnly
    ] = asyncRequestResponse[
      MergePullRequestBySquashRequest,
      MergePullRequestBySquashResponse
    ]("mergePullRequestBySquash", api.mergePullRequestBySquash)(
      request.buildAwsValue()
    ).map(zio.aws.codecommit.model.MergePullRequestBySquashResponse.wrap)
      .provideEnvironment(r)
    def getMergeCommit(
        request: zio.aws.codecommit.model.GetMergeCommitRequest
    ): IO[AwsError, zio.aws.codecommit.model.GetMergeCommitResponse.ReadOnly] =
      asyncRequestResponse[GetMergeCommitRequest, GetMergeCommitResponse](
        "getMergeCommit",
        api.getMergeCommit
      )(request.buildAwsValue())
        .map(zio.aws.codecommit.model.GetMergeCommitResponse.wrap)
        .provideEnvironment(r)
    def updateRepositoryDescription(
        request: zio.aws.codecommit.model.UpdateRepositoryDescriptionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdateRepositoryDescriptionRequest,
      UpdateRepositoryDescriptionResponse
    ]("updateRepositoryDescription", api.updateRepositoryDescription)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
  }
  def getCommentReactions(
      request: zio.aws.codecommit.model.GetCommentReactionsRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.GetCommentReactionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCommentReactions(request))
  def updatePullRequestApprovalRuleContent(
      request: zio.aws.codecommit.model.UpdatePullRequestApprovalRuleContentRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.UpdatePullRequestApprovalRuleContentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePullRequestApprovalRuleContent(request))
  def describeMergeConflicts(
      request: zio.aws.codecommit.model.DescribeMergeConflictsRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.DescribeMergeConflictsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMergeConflicts(request))
  def updateApprovalRuleTemplateContent(
      request: zio.aws.codecommit.model.UpdateApprovalRuleTemplateContentRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.UpdateApprovalRuleTemplateContentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApprovalRuleTemplateContent(request))
  def updateRepositoryName(
      request: zio.aws.codecommit.model.UpdateRepositoryNameRequest
  ): ZIO[zio.aws.codecommit.CodeCommit, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateRepositoryName(request))
  def getRepositoryTriggers(
      request: zio.aws.codecommit.model.GetRepositoryTriggersRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.GetRepositoryTriggersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRepositoryTriggers(request))
  def updatePullRequestTitle(
      request: zio.aws.codecommit.model.UpdatePullRequestTitleRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.UpdatePullRequestTitleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePullRequestTitle(request))
  def postCommentReply(
      request: zio.aws.codecommit.model.PostCommentReplyRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.PostCommentReplyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.postCommentReply(request))
  def deleteCommentContent(
      request: zio.aws.codecommit.model.DeleteCommentContentRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.DeleteCommentContentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCommentContent(request))
  def evaluatePullRequestApprovalRules(
      request: zio.aws.codecommit.model.EvaluatePullRequestApprovalRulesRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.EvaluatePullRequestApprovalRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.evaluatePullRequestApprovalRules(request))
  def overridePullRequestApprovalRules(
      request: zio.aws.codecommit.model.OverridePullRequestApprovalRulesRequest
  ): ZIO[zio.aws.codecommit.CodeCommit, AwsError, Unit] =
    ZIO.serviceWithZIO(_.overridePullRequestApprovalRules(request))
  def getDifferences(
      request: zio.aws.codecommit.model.GetDifferencesRequest
  ): ZStream[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.Difference.ReadOnly
  ] = ZStream.serviceWithStream(_.getDifferences(request))
  def getDifferencesPaginated(
      request: zio.aws.codecommit.model.GetDifferencesRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.GetDifferencesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDifferencesPaginated(request))
  def updatePullRequestApprovalState(
      request: zio.aws.codecommit.model.UpdatePullRequestApprovalStateRequest
  ): ZIO[zio.aws.codecommit.CodeCommit, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updatePullRequestApprovalState(request))
  def postCommentForPullRequest(
      request: zio.aws.codecommit.model.PostCommentForPullRequestRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.PostCommentForPullRequestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.postCommentForPullRequest(request))
  def getFile(
      request: zio.aws.codecommit.model.GetFileRequest
  ): ZIO[zio.aws.codecommit.CodeCommit, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getFile(request))
  def getPullRequestApprovalStates(
      request: zio.aws.codecommit.model.GetPullRequestApprovalStatesRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.GetPullRequestApprovalStatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPullRequestApprovalStates(request))
  def getRepository(
      request: zio.aws.codecommit.model.GetRepositoryRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.GetRepositoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRepository(request))
  def deleteBranch(request: zio.aws.codecommit.model.DeleteBranchRequest): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.DeleteBranchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBranch(request))
  def deleteRepository(
      request: zio.aws.codecommit.model.DeleteRepositoryRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.DeleteRepositoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRepository(request))
  def getCommit(request: zio.aws.codecommit.model.GetCommitRequest): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.GetCommitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCommit(request))
  def deleteApprovalRuleTemplate(
      request: zio.aws.codecommit.model.DeleteApprovalRuleTemplateRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.DeleteApprovalRuleTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApprovalRuleTemplate(request))
  def updateApprovalRuleTemplateDescription(
      request: zio.aws.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.UpdateApprovalRuleTemplateDescriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApprovalRuleTemplateDescription(request))
  def getMergeConflicts(
      request: zio.aws.codecommit.model.GetMergeConflictsRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.GetMergeConflictsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMergeConflicts(request))
  def updatePullRequestDescription(
      request: zio.aws.codecommit.model.UpdatePullRequestDescriptionRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.UpdatePullRequestDescriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePullRequestDescription(request))
  def testRepositoryTriggers(
      request: zio.aws.codecommit.model.TestRepositoryTriggersRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.TestRepositoryTriggersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testRepositoryTriggers(request))
  def getMergeOptions(
      request: zio.aws.codecommit.model.GetMergeOptionsRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.GetMergeOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMergeOptions(request))
  def batchGetRepositories(
      request: zio.aws.codecommit.model.BatchGetRepositoriesRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.BatchGetRepositoriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetRepositories(request))
  def getApprovalRuleTemplate(
      request: zio.aws.codecommit.model.GetApprovalRuleTemplateRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.GetApprovalRuleTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApprovalRuleTemplate(request))
  def createPullRequestApprovalRule(
      request: zio.aws.codecommit.model.CreatePullRequestApprovalRuleRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.CreatePullRequestApprovalRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPullRequestApprovalRule(request))
  def batchDisassociateApprovalRuleTemplateFromRepositories(
      request: zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.batchDisassociateApprovalRuleTemplateFromRepositories(request)
  )
  def createBranch(
      request: zio.aws.codecommit.model.CreateBranchRequest
  ): ZIO[zio.aws.codecommit.CodeCommit, AwsError, Unit] =
    ZIO.serviceWithZIO(_.createBranch(request))
  def getFolder(request: zio.aws.codecommit.model.GetFolderRequest): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.GetFolderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFolder(request))
  def createApprovalRuleTemplate(
      request: zio.aws.codecommit.model.CreateApprovalRuleTemplateRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.CreateApprovalRuleTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApprovalRuleTemplate(request))
  def createRepository(
      request: zio.aws.codecommit.model.CreateRepositoryRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.CreateRepositoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRepository(request))
  def updateComment(
      request: zio.aws.codecommit.model.UpdateCommentRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.UpdateCommentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateComment(request))
  def postCommentForComparedCommit(
      request: zio.aws.codecommit.model.PostCommentForComparedCommitRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.PostCommentForComparedCommitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.postCommentForComparedCommit(request))
  def createUnreferencedMergeCommit(
      request: zio.aws.codecommit.model.CreateUnreferencedMergeCommitRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.CreateUnreferencedMergeCommitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUnreferencedMergeCommit(request))
  def mergeBranchesByThreeWay(
      request: zio.aws.codecommit.model.MergeBranchesByThreeWayRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.MergeBranchesByThreeWayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.mergeBranchesByThreeWay(request))
  def listApprovalRuleTemplates(
      request: zio.aws.codecommit.model.ListApprovalRuleTemplatesRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.ListApprovalRuleTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApprovalRuleTemplates(request))
  def putRepositoryTriggers(
      request: zio.aws.codecommit.model.PutRepositoryTriggersRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.PutRepositoryTriggersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putRepositoryTriggers(request))
  def putFile(request: zio.aws.codecommit.model.PutFileRequest): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.PutFileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putFile(request))
  def describePullRequestEvents(
      request: zio.aws.codecommit.model.DescribePullRequestEventsRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.DescribePullRequestEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePullRequestEvents(request))
  def disassociateApprovalRuleTemplateFromRepository(
      request: zio.aws.codecommit.model.DisassociateApprovalRuleTemplateFromRepositoryRequest
  ): ZIO[zio.aws.codecommit.CodeCommit, AwsError, Unit] = ZIO.serviceWithZIO(
    _.disassociateApprovalRuleTemplateFromRepository(request)
  )
  def putCommentReaction(
      request: zio.aws.codecommit.model.PutCommentReactionRequest
  ): ZIO[zio.aws.codecommit.CodeCommit, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putCommentReaction(request))
  def listRepositoriesForApprovalRuleTemplate(
      request: zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRepositoriesForApprovalRuleTemplate(request))
  def getCommentsForComparedCommit(
      request: zio.aws.codecommit.model.GetCommentsForComparedCommitRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.GetCommentsForComparedCommitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCommentsForComparedCommit(request))
  def mergePullRequestByFastForward(
      request: zio.aws.codecommit.model.MergePullRequestByFastForwardRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.MergePullRequestByFastForwardResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.mergePullRequestByFastForward(request))
  def listAssociatedApprovalRuleTemplatesForRepository(
      request: zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listAssociatedApprovalRuleTemplatesForRepository(request)
  )
  def updateApprovalRuleTemplateName(
      request: zio.aws.codecommit.model.UpdateApprovalRuleTemplateNameRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.UpdateApprovalRuleTemplateNameResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApprovalRuleTemplateName(request))
  def listBranches(
      request: zio.aws.codecommit.model.ListBranchesRequest
  ): ZStream[zio.aws.codecommit.CodeCommit, AwsError, BranchName] =
    ZStream.serviceWithStream(_.listBranches(request))
  def listBranchesPaginated(
      request: zio.aws.codecommit.model.ListBranchesRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.ListBranchesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBranchesPaginated(request))
  def untagResource(
      request: zio.aws.codecommit.model.UntagResourceRequest
  ): ZIO[zio.aws.codecommit.CodeCommit, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def getPullRequestOverrideState(
      request: zio.aws.codecommit.model.GetPullRequestOverrideStateRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.GetPullRequestOverrideStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPullRequestOverrideState(request))
  def mergeBranchesBySquash(
      request: zio.aws.codecommit.model.MergeBranchesBySquashRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.MergeBranchesBySquashResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.mergeBranchesBySquash(request))
  def mergePullRequestByThreeWay(
      request: zio.aws.codecommit.model.MergePullRequestByThreeWayRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.MergePullRequestByThreeWayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.mergePullRequestByThreeWay(request))
  def batchAssociateApprovalRuleTemplateWithRepositories(
      request: zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.batchAssociateApprovalRuleTemplateWithRepositories(request)
  )
  def deleteFile(request: zio.aws.codecommit.model.DeleteFileRequest): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.DeleteFileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFile(request))
  def updatePullRequestStatus(
      request: zio.aws.codecommit.model.UpdatePullRequestStatusRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.UpdatePullRequestStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePullRequestStatus(request))
  def deletePullRequestApprovalRule(
      request: zio.aws.codecommit.model.DeletePullRequestApprovalRuleRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.DeletePullRequestApprovalRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePullRequestApprovalRule(request))
  def listRepositories(
      request: zio.aws.codecommit.model.ListRepositoriesRequest
  ): ZStream[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.RepositoryNameIdPair.ReadOnly
  ] = ZStream.serviceWithStream(_.listRepositories(request))
  def listRepositoriesPaginated(
      request: zio.aws.codecommit.model.ListRepositoriesRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.ListRepositoriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRepositoriesPaginated(request))
  def getBranch(request: zio.aws.codecommit.model.GetBranchRequest): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.GetBranchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBranch(request))
  def getCommentsForPullRequest(
      request: zio.aws.codecommit.model.GetCommentsForPullRequestRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.GetCommentsForPullRequestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCommentsForPullRequest(request))
  def batchGetCommits(
      request: zio.aws.codecommit.model.BatchGetCommitsRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.BatchGetCommitsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetCommits(request))
  def mergeBranchesByFastForward(
      request: zio.aws.codecommit.model.MergeBranchesByFastForwardRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.MergeBranchesByFastForwardResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.mergeBranchesByFastForward(request))
  def listTagsForResource(
      request: zio.aws.codecommit.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def associateApprovalRuleTemplateWithRepository(
      request: zio.aws.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryRequest
  ): ZIO[zio.aws.codecommit.CodeCommit, AwsError, Unit] =
    ZIO.serviceWithZIO(_.associateApprovalRuleTemplateWithRepository(request))
  def tagResource(
      request: zio.aws.codecommit.model.TagResourceRequest
  ): ZIO[zio.aws.codecommit.CodeCommit, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def createCommit(request: zio.aws.codecommit.model.CreateCommitRequest): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.CreateCommitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCommit(request))
  def updateDefaultBranch(
      request: zio.aws.codecommit.model.UpdateDefaultBranchRequest
  ): ZIO[zio.aws.codecommit.CodeCommit, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateDefaultBranch(request))
  def getBlob(request: zio.aws.codecommit.model.GetBlobRequest): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.GetBlobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBlob(request))
  def getPullRequest(
      request: zio.aws.codecommit.model.GetPullRequestRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.GetPullRequestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPullRequest(request))
  def getComment(request: zio.aws.codecommit.model.GetCommentRequest): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.GetCommentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getComment(request))
  def listPullRequests(
      request: zio.aws.codecommit.model.ListPullRequestsRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.ListPullRequestsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPullRequests(request))
  def batchDescribeMergeConflicts(
      request: zio.aws.codecommit.model.BatchDescribeMergeConflictsRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.BatchDescribeMergeConflictsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDescribeMergeConflicts(request))
  def createPullRequest(
      request: zio.aws.codecommit.model.CreatePullRequestRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.CreatePullRequestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPullRequest(request))
  def mergePullRequestBySquash(
      request: zio.aws.codecommit.model.MergePullRequestBySquashRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.MergePullRequestBySquashResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.mergePullRequestBySquash(request))
  def getMergeCommit(
      request: zio.aws.codecommit.model.GetMergeCommitRequest
  ): ZIO[
    zio.aws.codecommit.CodeCommit,
    AwsError,
    zio.aws.codecommit.model.GetMergeCommitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMergeCommit(request))
  def updateRepositoryDescription(
      request: zio.aws.codecommit.model.UpdateRepositoryDescriptionRequest
  ): ZIO[zio.aws.codecommit.CodeCommit, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateRepositoryDescription(request))
}
