package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{ErrorMessage, ErrorCode, ObjectId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchGetCommitsError(
    commitId: Option[ObjectId] = None,
    errorCode: Option[ErrorCode] = None,
    errorMessage: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.BatchGetCommitsError = {
    import BatchGetCommitsError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.BatchGetCommitsError
      .builder()
      .optionallyWith(
        commitId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.commitId)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.BatchGetCommitsError.ReadOnly =
    zio.aws.codecommit.model.BatchGetCommitsError.wrap(buildAwsValue())
}
object BatchGetCommitsError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.BatchGetCommitsError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.BatchGetCommitsError =
      zio.aws.codecommit.model.BatchGetCommitsError(
        commitId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def commitId: Option[ObjectId]
    def errorCode: Option[ErrorCode]
    def errorMessage: Option[ErrorMessage]
    def getCommitId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("commitId", commitId)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.BatchGetCommitsError
  ) extends zio.aws.codecommit.model.BatchGetCommitsError.ReadOnly {
    override val commitId: Option[ObjectId] = scala
      .Option(impl.commitId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val errorCode: Option[ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.codecommit.model.primitives.ErrorCode(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.codecommit.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.BatchGetCommitsError
  ): zio.aws.codecommit.model.BatchGetCommitsError.ReadOnly = new Wrapper(impl)
}
