package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ErrorMessage,
  ErrorCode,
  RepositoryName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchDisassociateApprovalRuleTemplateFromRepositoriesError(
    repositoryName: Option[RepositoryName] = None,
    errorCode: Option[ErrorCode] = None,
    errorMessage: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError = {
    import BatchDisassociateApprovalRuleTemplateFromRepositoriesError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError
      .builder()
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError.ReadOnly =
    zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError
      .wrap(buildAwsValue())
}
object BatchDisassociateApprovalRuleTemplateFromRepositoriesError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError =
      zio.aws.codecommit.model
        .BatchDisassociateApprovalRuleTemplateFromRepositoriesError(
          repositoryName.map(value => value),
          errorCode.map(value => value),
          errorMessage.map(value => value)
        )
    def repositoryName: Option[RepositoryName]
    def errorCode: Option[ErrorCode]
    def errorMessage: Option[ErrorMessage]
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError
  ) extends zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError.ReadOnly {
    override val repositoryName: Option[RepositoryName] = scala
      .Option(impl.repositoryName())
      .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val errorCode: Option[ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.codecommit.model.primitives.ErrorCode(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.codecommit.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError
  ): zio.aws.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesError.ReadOnly =
    new Wrapper(impl)
}
