package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ObjectId,
  CommitId,
  PullRequestId,
  RepositoryName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PostCommentForPullRequestResponse(
    repositoryName: Option[RepositoryName] = None,
    pullRequestId: Option[PullRequestId] = None,
    beforeCommitId: Option[CommitId] = None,
    afterCommitId: Option[CommitId] = None,
    beforeBlobId: Option[ObjectId] = None,
    afterBlobId: Option[ObjectId] = None,
    location: Option[zio.aws.codecommit.model.Location] = None,
    comment: Option[zio.aws.codecommit.model.Comment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestResponse = {
    import PostCommentForPullRequestResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestResponse
      .builder()
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        pullRequestId.map(value =>
          PullRequestId.unwrap(value): java.lang.String
        )
      )(_.pullRequestId)
      .optionallyWith(
        beforeCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.beforeCommitId)
      .optionallyWith(
        afterCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.afterCommitId)
      .optionallyWith(
        beforeBlobId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.beforeBlobId)
      .optionallyWith(
        afterBlobId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.afterBlobId)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(comment.map(value => value.buildAwsValue()))(_.comment)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.PostCommentForPullRequestResponse.ReadOnly =
    zio.aws.codecommit.model.PostCommentForPullRequestResponse
      .wrap(buildAwsValue())
}
object PostCommentForPullRequestResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.PostCommentForPullRequestResponse =
      zio.aws.codecommit.model.PostCommentForPullRequestResponse(
        repositoryName.map(value => value),
        pullRequestId.map(value => value),
        beforeCommitId.map(value => value),
        afterCommitId.map(value => value),
        beforeBlobId.map(value => value),
        afterBlobId.map(value => value),
        location.map(value => value.asEditable),
        comment.map(value => value.asEditable)
      )
    def repositoryName: Option[RepositoryName]
    def pullRequestId: Option[PullRequestId]
    def beforeCommitId: Option[CommitId]
    def afterCommitId: Option[CommitId]
    def beforeBlobId: Option[ObjectId]
    def afterBlobId: Option[ObjectId]
    def location: Option[zio.aws.codecommit.model.Location.ReadOnly]
    def comment: Option[zio.aws.codecommit.model.Comment.ReadOnly]
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getPullRequestId: ZIO[Any, AwsError, PullRequestId] =
      AwsError.unwrapOptionField("pullRequestId", pullRequestId)
    def getBeforeCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("beforeCommitId", beforeCommitId)
    def getAfterCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("afterCommitId", afterCommitId)
    def getBeforeBlobId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("beforeBlobId", beforeBlobId)
    def getAfterBlobId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("afterBlobId", afterBlobId)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.codecommit.model.Location.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getComment
        : ZIO[Any, AwsError, zio.aws.codecommit.model.Comment.ReadOnly] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestResponse
  ) extends zio.aws.codecommit.model.PostCommentForPullRequestResponse.ReadOnly {
    override val repositoryName: Option[RepositoryName] = scala
      .Option(impl.repositoryName())
      .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val pullRequestId: Option[PullRequestId] = scala
      .Option(impl.pullRequestId())
      .map(value => zio.aws.codecommit.model.primitives.PullRequestId(value))
    override val beforeCommitId: Option[CommitId] = scala
      .Option(impl.beforeCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val afterCommitId: Option[CommitId] = scala
      .Option(impl.afterCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val beforeBlobId: Option[ObjectId] = scala
      .Option(impl.beforeBlobId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val afterBlobId: Option[ObjectId] = scala
      .Option(impl.afterBlobId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val location: Option[zio.aws.codecommit.model.Location.ReadOnly] =
      scala
        .Option(impl.location())
        .map(value => zio.aws.codecommit.model.Location.wrap(value))
    override val comment: Option[zio.aws.codecommit.model.Comment.ReadOnly] =
      scala
        .Option(impl.comment())
        .map(value => zio.aws.codecommit.model.Comment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestResponse
  ): zio.aws.codecommit.model.PostCommentForPullRequestResponse.ReadOnly =
    new Wrapper(impl)
}
