package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.RevisionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ApprovalRuleOverriddenEventMetadata(
    revisionId: Option[RevisionId] = None,
    overrideStatus: Option[zio.aws.codecommit.model.OverrideStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ApprovalRuleOverriddenEventMetadata = {
    import ApprovalRuleOverriddenEventMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ApprovalRuleOverriddenEventMetadata
      .builder()
      .optionallyWith(
        revisionId.map(value => RevisionId.unwrap(value): java.lang.String)
      )(_.revisionId)
      .optionallyWith(overrideStatus.map(value => value.unwrap))(
        _.overrideStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.ApprovalRuleOverriddenEventMetadata.ReadOnly =
    zio.aws.codecommit.model.ApprovalRuleOverriddenEventMetadata
      .wrap(buildAwsValue())
}
object ApprovalRuleOverriddenEventMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ApprovalRuleOverriddenEventMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.ApprovalRuleOverriddenEventMetadata =
      zio.aws.codecommit.model.ApprovalRuleOverriddenEventMetadata(
        revisionId.map(value => value),
        overrideStatus.map(value => value)
      )
    def revisionId: Option[RevisionId]
    def overrideStatus: Option[zio.aws.codecommit.model.OverrideStatus]
    def getRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getOverrideStatus
        : ZIO[Any, AwsError, zio.aws.codecommit.model.OverrideStatus] =
      AwsError.unwrapOptionField("overrideStatus", overrideStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ApprovalRuleOverriddenEventMetadata
  ) extends zio.aws.codecommit.model.ApprovalRuleOverriddenEventMetadata.ReadOnly {
    override val revisionId: Option[RevisionId] = scala
      .Option(impl.revisionId())
      .map(value => zio.aws.codecommit.model.primitives.RevisionId(value))
    override val overrideStatus
        : Option[zio.aws.codecommit.model.OverrideStatus] = scala
      .Option(impl.overrideStatus())
      .map(value => zio.aws.codecommit.model.OverrideStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ApprovalRuleOverriddenEventMetadata
  ): zio.aws.codecommit.model.ApprovalRuleOverriddenEventMetadata.ReadOnly =
    new Wrapper(impl)
}
