package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{ReferenceName, RepositoryName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PullRequestMergedStateChangedEventMetadata(
    repositoryName: Option[RepositoryName] = None,
    destinationReference: Option[ReferenceName] = None,
    mergeMetadata: Option[zio.aws.codecommit.model.MergeMetadata] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PullRequestMergedStateChangedEventMetadata = {
    import PullRequestMergedStateChangedEventMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PullRequestMergedStateChangedEventMetadata
      .builder()
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        destinationReference.map(value =>
          ReferenceName.unwrap(value): java.lang.String
        )
      )(_.destinationReference)
      .optionallyWith(mergeMetadata.map(value => value.buildAwsValue()))(
        _.mergeMetadata
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.PullRequestMergedStateChangedEventMetadata.ReadOnly =
    zio.aws.codecommit.model.PullRequestMergedStateChangedEventMetadata
      .wrap(buildAwsValue())
}
object PullRequestMergedStateChangedEventMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PullRequestMergedStateChangedEventMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.PullRequestMergedStateChangedEventMetadata =
      zio.aws.codecommit.model.PullRequestMergedStateChangedEventMetadata(
        repositoryName.map(value => value),
        destinationReference.map(value => value),
        mergeMetadata.map(value => value.asEditable)
      )
    def repositoryName: Option[RepositoryName]
    def destinationReference: Option[ReferenceName]
    def mergeMetadata: Option[zio.aws.codecommit.model.MergeMetadata.ReadOnly]
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getDestinationReference: ZIO[Any, AwsError, ReferenceName] =
      AwsError.unwrapOptionField("destinationReference", destinationReference)
    def getMergeMetadata
        : ZIO[Any, AwsError, zio.aws.codecommit.model.MergeMetadata.ReadOnly] =
      AwsError.unwrapOptionField("mergeMetadata", mergeMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequestMergedStateChangedEventMetadata
  ) extends zio.aws.codecommit.model.PullRequestMergedStateChangedEventMetadata.ReadOnly {
    override val repositoryName: Option[RepositoryName] = scala
      .Option(impl.repositoryName())
      .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val destinationReference: Option[ReferenceName] = scala
      .Option(impl.destinationReference())
      .map(value => zio.aws.codecommit.model.primitives.ReferenceName(value))
    override val mergeMetadata
        : Option[zio.aws.codecommit.model.MergeMetadata.ReadOnly] = scala
      .Option(impl.mergeMetadata())
      .map(value => zio.aws.codecommit.model.MergeMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequestMergedStateChangedEventMetadata
  ): zio.aws.codecommit.model.PullRequestMergedStateChangedEventMetadata.ReadOnly =
    new Wrapper(impl)
}
