package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{AdditionalData, Message, ObjectId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Commit(
    commitId: Option[ObjectId] = None,
    treeId: Option[ObjectId] = None,
    parents: Option[Iterable[ObjectId]] = None,
    message: Option[Message] = None,
    author: Option[zio.aws.codecommit.model.UserInfo] = None,
    committer: Option[zio.aws.codecommit.model.UserInfo] = None,
    additionalData: Option[AdditionalData] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.Commit = {
    import Commit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.Commit
      .builder()
      .optionallyWith(
        commitId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.commitId)
      .optionallyWith(
        treeId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.treeId)
      .optionallyWith(
        parents.map(value =>
          value.map { item =>
            ObjectId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.parents)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(author.map(value => value.buildAwsValue()))(_.author)
      .optionallyWith(committer.map(value => value.buildAwsValue()))(
        _.committer
      )
      .optionallyWith(
        additionalData.map(value =>
          AdditionalData.unwrap(value): java.lang.String
        )
      )(_.additionalData)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.Commit.ReadOnly =
    zio.aws.codecommit.model.Commit.wrap(buildAwsValue())
}
object Commit {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.codecommit.model.Commit] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.Commit =
      zio.aws.codecommit.model.Commit(
        commitId.map(value => value),
        treeId.map(value => value),
        parents.map(value => value),
        message.map(value => value),
        author.map(value => value.asEditable),
        committer.map(value => value.asEditable),
        additionalData.map(value => value)
      )
    def commitId: Option[ObjectId]
    def treeId: Option[ObjectId]
    def parents: Option[List[ObjectId]]
    def message: Option[Message]
    def author: Option[zio.aws.codecommit.model.UserInfo.ReadOnly]
    def committer: Option[zio.aws.codecommit.model.UserInfo.ReadOnly]
    def additionalData: Option[AdditionalData]
    def getCommitId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("commitId", commitId)
    def getTreeId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("treeId", treeId)
    def getParents: ZIO[Any, AwsError, List[ObjectId]] =
      AwsError.unwrapOptionField("parents", parents)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getAuthor
        : ZIO[Any, AwsError, zio.aws.codecommit.model.UserInfo.ReadOnly] =
      AwsError.unwrapOptionField("author", author)
    def getCommitter
        : ZIO[Any, AwsError, zio.aws.codecommit.model.UserInfo.ReadOnly] =
      AwsError.unwrapOptionField("committer", committer)
    def getAdditionalData: ZIO[Any, AwsError, AdditionalData] =
      AwsError.unwrapOptionField("additionalData", additionalData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.Commit
  ) extends zio.aws.codecommit.model.Commit.ReadOnly {
    override val commitId: Option[ObjectId] = scala
      .Option(impl.commitId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val treeId: Option[ObjectId] = scala
      .Option(impl.treeId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val parents: Option[List[ObjectId]] = scala
      .Option(impl.parents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.primitives.ObjectId(item)
        }.toList
      )
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.codecommit.model.primitives.Message(value))
    override val author: Option[zio.aws.codecommit.model.UserInfo.ReadOnly] =
      scala
        .Option(impl.author())
        .map(value => zio.aws.codecommit.model.UserInfo.wrap(value))
    override val committer: Option[zio.aws.codecommit.model.UserInfo.ReadOnly] =
      scala
        .Option(impl.committer())
        .map(value => zio.aws.codecommit.model.UserInfo.wrap(value))
    override val additionalData: Option[AdditionalData] = scala
      .Option(impl.additionalData())
      .map(value => zio.aws.codecommit.model.primitives.AdditionalData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.Commit
  ): zio.aws.codecommit.model.Commit.ReadOnly = new Wrapper(impl)
}
