package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.RepositoryName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchGetRepositoriesResponse(
    repositories: Option[
      Iterable[zio.aws.codecommit.model.RepositoryMetadata]
    ] = None,
    repositoriesNotFound: Option[Iterable[RepositoryName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesResponse = {
    import BatchGetRepositoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesResponse
      .builder()
      .optionallyWith(
        repositories.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.repositories)
      .optionallyWith(
        repositoriesNotFound.map(value =>
          value.map { item =>
            RepositoryName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.repositoriesNotFound)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.BatchGetRepositoriesResponse.ReadOnly =
    zio.aws.codecommit.model.BatchGetRepositoriesResponse.wrap(buildAwsValue())
}
object BatchGetRepositoriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.BatchGetRepositoriesResponse =
      zio.aws.codecommit.model.BatchGetRepositoriesResponse(
        repositories.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        repositoriesNotFound.map(value => value)
      )
    def repositories
        : Option[List[zio.aws.codecommit.model.RepositoryMetadata.ReadOnly]]
    def repositoriesNotFound: Option[List[RepositoryName]]
    def getRepositories: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.RepositoryMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("repositories", repositories)
    def getRepositoriesNotFound: ZIO[Any, AwsError, List[RepositoryName]] =
      AwsError.unwrapOptionField("repositoriesNotFound", repositoriesNotFound)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesResponse
  ) extends zio.aws.codecommit.model.BatchGetRepositoriesResponse.ReadOnly {
    override val repositories
        : Option[List[zio.aws.codecommit.model.RepositoryMetadata.ReadOnly]] =
      scala
        .Option(impl.repositories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.RepositoryMetadata.wrap(item)
          }.toList
        )
    override val repositoriesNotFound: Option[List[RepositoryName]] = scala
      .Option(impl.repositoriesNotFound())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.primitives.RepositoryName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesResponse
  ): zio.aws.codecommit.model.BatchGetRepositoriesResponse.ReadOnly =
    new Wrapper(impl)
}
