package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBranchResponse(
    branch: Option[zio.aws.codecommit.model.BranchInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetBranchResponse = {
    import GetBranchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetBranchResponse
      .builder()
      .optionallyWith(branch.map(value => value.buildAwsValue()))(_.branch)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetBranchResponse.ReadOnly =
    zio.aws.codecommit.model.GetBranchResponse.wrap(buildAwsValue())
}
object GetBranchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetBranchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetBranchResponse =
      zio.aws.codecommit.model
        .GetBranchResponse(branch.map(value => value.asEditable))
    def branch: Option[zio.aws.codecommit.model.BranchInfo.ReadOnly]
    def getBranch
        : ZIO[Any, AwsError, zio.aws.codecommit.model.BranchInfo.ReadOnly] =
      AwsError.unwrapOptionField("branch", branch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetBranchResponse
  ) extends zio.aws.codecommit.model.GetBranchResponse.ReadOnly {
    override val branch: Option[zio.aws.codecommit.model.BranchInfo.ReadOnly] =
      scala
        .Option(impl.branch())
        .map(value => zio.aws.codecommit.model.BranchInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetBranchResponse
  ): zio.aws.codecommit.model.GetBranchResponse.ReadOnly = new Wrapper(impl)
}
