package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  IsObjectTypeConflict,
  IsContentConflict,
  Path,
  IsFileModeConflict,
  NumberOfConflicts
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ConflictMetadata(
    filePath: Option[Path] = None,
    fileSizes: Option[zio.aws.codecommit.model.FileSizes] = None,
    fileModes: Option[zio.aws.codecommit.model.FileModes] = None,
    objectTypes: Option[zio.aws.codecommit.model.ObjectTypes] = None,
    numberOfConflicts: Option[NumberOfConflicts] = None,
    isBinaryFile: Option[zio.aws.codecommit.model.IsBinaryFile] = None,
    contentConflict: Option[IsContentConflict] = None,
    fileModeConflict: Option[IsFileModeConflict] = None,
    objectTypeConflict: Option[IsObjectTypeConflict] = None,
    mergeOperations: Option[zio.aws.codecommit.model.MergeOperations] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ConflictMetadata = {
    import ConflictMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ConflictMetadata
      .builder()
      .optionallyWith(
        filePath.map(value => Path.unwrap(value): java.lang.String)
      )(_.filePath)
      .optionallyWith(fileSizes.map(value => value.buildAwsValue()))(
        _.fileSizes
      )
      .optionallyWith(fileModes.map(value => value.buildAwsValue()))(
        _.fileModes
      )
      .optionallyWith(objectTypes.map(value => value.buildAwsValue()))(
        _.objectTypes
      )
      .optionallyWith(
        numberOfConflicts.map(value => NumberOfConflicts.unwrap(value): Integer)
      )(_.numberOfConflicts)
      .optionallyWith(isBinaryFile.map(value => value.buildAwsValue()))(
        _.isBinaryFile
      )
      .optionallyWith(
        contentConflict.map(value =>
          IsContentConflict.unwrap(value): java.lang.Boolean
        )
      )(_.contentConflict)
      .optionallyWith(
        fileModeConflict.map(value =>
          IsFileModeConflict.unwrap(value): java.lang.Boolean
        )
      )(_.fileModeConflict)
      .optionallyWith(
        objectTypeConflict.map(value =>
          IsObjectTypeConflict.unwrap(value): java.lang.Boolean
        )
      )(_.objectTypeConflict)
      .optionallyWith(mergeOperations.map(value => value.buildAwsValue()))(
        _.mergeOperations
      )
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.ConflictMetadata.ReadOnly =
    zio.aws.codecommit.model.ConflictMetadata.wrap(buildAwsValue())
}
object ConflictMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ConflictMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ConflictMetadata =
      zio.aws.codecommit.model.ConflictMetadata(
        filePath.map(value => value),
        fileSizes.map(value => value.asEditable),
        fileModes.map(value => value.asEditable),
        objectTypes.map(value => value.asEditable),
        numberOfConflicts.map(value => value),
        isBinaryFile.map(value => value.asEditable),
        contentConflict.map(value => value),
        fileModeConflict.map(value => value),
        objectTypeConflict.map(value => value),
        mergeOperations.map(value => value.asEditable)
      )
    def filePath: Option[Path]
    def fileSizes: Option[zio.aws.codecommit.model.FileSizes.ReadOnly]
    def fileModes: Option[zio.aws.codecommit.model.FileModes.ReadOnly]
    def objectTypes: Option[zio.aws.codecommit.model.ObjectTypes.ReadOnly]
    def numberOfConflicts: Option[NumberOfConflicts]
    def isBinaryFile: Option[zio.aws.codecommit.model.IsBinaryFile.ReadOnly]
    def contentConflict: Option[IsContentConflict]
    def fileModeConflict: Option[IsFileModeConflict]
    def objectTypeConflict: Option[IsObjectTypeConflict]
    def mergeOperations
        : Option[zio.aws.codecommit.model.MergeOperations.ReadOnly]
    def getFilePath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("filePath", filePath)
    def getFileSizes
        : ZIO[Any, AwsError, zio.aws.codecommit.model.FileSizes.ReadOnly] =
      AwsError.unwrapOptionField("fileSizes", fileSizes)
    def getFileModes
        : ZIO[Any, AwsError, zio.aws.codecommit.model.FileModes.ReadOnly] =
      AwsError.unwrapOptionField("fileModes", fileModes)
    def getObjectTypes
        : ZIO[Any, AwsError, zio.aws.codecommit.model.ObjectTypes.ReadOnly] =
      AwsError.unwrapOptionField("objectTypes", objectTypes)
    def getNumberOfConflicts: ZIO[Any, AwsError, NumberOfConflicts] =
      AwsError.unwrapOptionField("numberOfConflicts", numberOfConflicts)
    def getIsBinaryFile
        : ZIO[Any, AwsError, zio.aws.codecommit.model.IsBinaryFile.ReadOnly] =
      AwsError.unwrapOptionField("isBinaryFile", isBinaryFile)
    def getContentConflict: ZIO[Any, AwsError, IsContentConflict] =
      AwsError.unwrapOptionField("contentConflict", contentConflict)
    def getFileModeConflict: ZIO[Any, AwsError, IsFileModeConflict] =
      AwsError.unwrapOptionField("fileModeConflict", fileModeConflict)
    def getObjectTypeConflict: ZIO[Any, AwsError, IsObjectTypeConflict] =
      AwsError.unwrapOptionField("objectTypeConflict", objectTypeConflict)
    def getMergeOperations: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.MergeOperations.ReadOnly
    ] = AwsError.unwrapOptionField("mergeOperations", mergeOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ConflictMetadata
  ) extends zio.aws.codecommit.model.ConflictMetadata.ReadOnly {
    override val filePath: Option[Path] = scala
      .Option(impl.filePath())
      .map(value => zio.aws.codecommit.model.primitives.Path(value))
    override val fileSizes
        : Option[zio.aws.codecommit.model.FileSizes.ReadOnly] = scala
      .Option(impl.fileSizes())
      .map(value => zio.aws.codecommit.model.FileSizes.wrap(value))
    override val fileModes
        : Option[zio.aws.codecommit.model.FileModes.ReadOnly] = scala
      .Option(impl.fileModes())
      .map(value => zio.aws.codecommit.model.FileModes.wrap(value))
    override val objectTypes
        : Option[zio.aws.codecommit.model.ObjectTypes.ReadOnly] = scala
      .Option(impl.objectTypes())
      .map(value => zio.aws.codecommit.model.ObjectTypes.wrap(value))
    override val numberOfConflicts: Option[NumberOfConflicts] = scala
      .Option(impl.numberOfConflicts())
      .map(value =>
        zio.aws.codecommit.model.primitives.NumberOfConflicts(value)
      )
    override val isBinaryFile
        : Option[zio.aws.codecommit.model.IsBinaryFile.ReadOnly] = scala
      .Option(impl.isBinaryFile())
      .map(value => zio.aws.codecommit.model.IsBinaryFile.wrap(value))
    override val contentConflict: Option[IsContentConflict] = scala
      .Option(impl.contentConflict())
      .map(value =>
        zio.aws.codecommit.model.primitives.IsContentConflict(value)
      )
    override val fileModeConflict: Option[IsFileModeConflict] = scala
      .Option(impl.fileModeConflict())
      .map(value =>
        zio.aws.codecommit.model.primitives.IsFileModeConflict(value)
      )
    override val objectTypeConflict: Option[IsObjectTypeConflict] = scala
      .Option(impl.objectTypeConflict())
      .map(value =>
        zio.aws.codecommit.model.primitives.IsObjectTypeConflict(value)
      )
    override val mergeOperations
        : Option[zio.aws.codecommit.model.MergeOperations.ReadOnly] = scala
      .Option(impl.mergeOperations())
      .map(value => zio.aws.codecommit.model.MergeOperations.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ConflictMetadata
  ): zio.aws.codecommit.model.ConflictMetadata.ReadOnly = new Wrapper(impl)
}
